/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.sasl.CelebornSaslClient;
import org.apache.celeborn.common.network.sasl.SaslCredentials;
import org.apache.celeborn.common.network.sasl.SaslTimeoutException;
import org.apache.celeborn.common.network.sasl.SaslUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PbAuthType;
import org.apache.celeborn.common.protocol.PbSaslRequest;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.apache.celeborn.shaded.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientBootstrap
implements TransportClientBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(SaslClientBootstrap.class);
    private final TransportConf conf;
    private final String appId;
    private final SaslCredentials saslCredentials;

    public SaslClientBootstrap(TransportConf conf, String appId, SaslCredentials saslCredentials) {
        this.conf = conf;
        this.appId = appId;
        this.saslCredentials = Preconditions.checkNotNull(saslCredentials);
    }

    @Override
    public void doBootstrap(TransportClient client) {
        CelebornSaslClient saslClient = new CelebornSaslClient("DIGEST-MD5", SaslUtils.DEFAULT_SASL_CLIENT_PROPS, new CelebornSaslClient.ClientCallbackHandler(this.saslCredentials.getUserId(), this.saslCredentials.getPassword()));
        try {
            byte[] payload = saslClient.firstToken();
            boolean firstToken = true;
            while (!saslClient.isComplete()) {
                ByteBuffer response;
                PbSaslRequest.Builder builder = PbSaslRequest.newBuilder();
                if (firstToken) {
                    builder.setMethod("DIGEST-MD5");
                }
                builder.setAuthType(PbAuthType.CONNECTION_AUTH);
                TransportMessage msg = new TransportMessage(MessageType.SASL_REQUEST, builder.setPayload(ByteString.copyFrom(payload)).build().toByteArray());
                try {
                    response = client.sendRpcSync(msg.toByteBuffer(), this.conf.saslTimeoutMs());
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof TimeoutException) {
                        throw new SaslTimeoutException(ex.getCause());
                    }
                    throw ex;
                }
                payload = saslClient.response(JavaUtils.bufferToArray(response));
                firstToken = false;
            }
            client.setClientId(this.appId);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                saslClient.dispose();
            }
            catch (RuntimeException e) {
                logger.error("Error while disposing SASL client", (Throwable)e);
            }
        }
    }
}

