/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestNodeAddData {
    private static final String TEST_NODENAME = "testNewNode";
    private static final String PATH_NODE_NAME = "PATHNODE";
    private static ImmutableNode parentNode;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        parentNode = new ImmutableNode.Builder().name("testParent").create();
    }

    @Test
    void testInitPathNodesDefensiveCopy() {
        ArrayList<String> pathNodes = new ArrayList<String>();
        pathNodes.add(PATH_NODE_NAME);
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, pathNodes);
        pathNodes.add("anotherNode");
        Assertions.assertEquals(Arrays.asList(PATH_NODE_NAME), (Object)data.getPathNodes());
    }

    @Test
    void testPathNodesDefinedModify() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, Collections.singleton(PATH_NODE_NAME));
        List pathNodes = data.getPathNodes();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> pathNodes.add("anotherNode"));
    }

    @Test
    void testPathNodesNull() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, null);
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
    }

    @Test
    void testPathNodesNullModify() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, null);
        List pathNodes = data.getPathNodes();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> pathNodes.add("test"));
    }
}

