/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.Extension;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;
import org.apache.commons.imaging.formats.png.chunks.PngChunkGama;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIccp;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIdat;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIhdr;
import org.apache.commons.imaging.formats.png.chunks.PngChunkItxt;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPhys;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.chunks.PngChunkScal;
import org.apache.commons.imaging.formats.png.chunks.PngChunkText;
import org.apache.commons.imaging.formats.png.chunks.PngChunkZtxt;

public enum ChunkType {
    IHDR(PngChunkIhdr::new),
    PLTE(PngChunkPlte::new),
    IDAT(PngChunkIdat::new),
    IEND,
    tRNS,
    cHRM,
    gAMA(PngChunkGama::new),
    iCCP(PngChunkIccp::new),
    sBIT,
    sRGB,
    tEXt(PngChunkText::new),
    zTXt(PngChunkZtxt::new),
    iTXt(PngChunkItxt::new),
    bKGD,
    hIST,
    pHYs(PngChunkPhys::new),
    sPLT,
    tIME,
    oFFs(Extension.PNGEXT),
    pCAL(Extension.PNGEXT),
    sCAL(Extension.PNGEXT, PngChunkScal::new),
    gIFg(Extension.PNGEXT),
    gIFx(Extension.PNGEXT),
    sTER(Extension.PNGEXT),
    eXIf(Extension.PNGEXT);

    private static final ChunkType[] types;
    final byte[] array;
    final int value;
    final Extension extension;
    final ChunkConstructor constructor;

    static ChunkType findType(int chunkType) {
        for (ChunkType type : types) {
            if (type.value != chunkType) continue;
            return type;
        }
        return null;
    }

    static PngChunk makeChunk(int length, int chunkType, int crc, byte[] bytes) throws IOException {
        ChunkType type = ChunkType.findType(chunkType);
        return type != null && type.constructor != null ? type.constructor.make(length, chunkType, crc, bytes) : new PngChunk(length, chunkType, crc, bytes);
    }

    private ChunkType() {
        this(null, null);
    }

    private ChunkType(ChunkConstructor constructor) {
        this(null, constructor);
    }

    private ChunkType(Extension extension) {
        this(extension, null);
    }

    private ChunkType(Extension extension, ChunkConstructor constructor) {
        char[] chars = this.name().toCharArray();
        this.array = this.name().getBytes(StandardCharsets.UTF_8);
        this.value = BinaryFunctions.charsToQuad(chars[0], chars[1], chars[2], chars[3]);
        this.extension = extension;
        this.constructor = constructor;
    }

    static {
        types = ChunkType.values();
    }

    @FunctionalInterface
    private static interface ChunkConstructor {
        public PngChunk make(int var1, int var2, int var3, byte[] var4) throws IOException;
    }
}

