/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.jexl2.Script;

public class ScriptCallableTest
extends JexlTestCase {
    public void testFuture() throws Exception {
        Script e = this.JEXL.createScript("while(true);");
        FutureTask future = new FutureTask(e.callable(null));
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(future);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        Thread.sleep(100L);
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public void testCallable() throws Exception {
        Script e = this.JEXL.createScript("while(true);");
        Callable c = e.callable(null);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public void testNoWait() throws Exception {
        Script e = this.JEXL.createScript("wait(0)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        Object t = future.get(2L, TimeUnit.SECONDS);
        ScriptCallableTest.assertTrue((boolean)future.isDone());
        ScriptCallableTest.assertEquals((Object)0, t);
    }

    public void testWait() throws Exception {
        Script e = this.JEXL.createScript("wait(1)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        Object t = future.get(2L, TimeUnit.SECONDS);
        ScriptCallableTest.assertEquals((Object)1, t);
    }

    public void testCancelWait() throws Exception {
        Script e = this.JEXL.createScript("wait(10)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public void testCancelWaitInterrupt() throws Exception {
        Script e = this.JEXL.createScript("waitInterrupt(42)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public void testCancelForever() throws Exception {
        Script e = this.JEXL.createScript("runForever()");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public void testCancelLoopWait() throws Exception {
        Script e = this.JEXL.createScript("while (true) { wait(10) }");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            ScriptCallableTest.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            // empty catch block
        }
        future.cancel(true);
        ScriptCallableTest.assertTrue((boolean)future.isCancelled());
    }

    public static class TestContext
    extends MapContext
    implements NamespaceResolver {
        public Object resolveNamespace(String name) {
            return name == null ? this : null;
        }

        public int wait(int s) throws InterruptedException {
            Thread.sleep(1000 * s);
            return s;
        }

        public int waitInterrupt(int s) {
            try {
                Thread.sleep(1000 * s);
                return s;
            }
            catch (InterruptedException xint) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }

        public int runForever() {
            boolean x = false;
            while (!x) {
            }
            return 1;
        }
    }
}

