/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

public abstract class HandlerBase {
    private final Counter cachedCounter = new Counter();
    private static final ThreadLocal<Counter> counterThreadLocal = new ThreadLocal();

    protected void enter() {
        Counter counter = counterThreadLocal.get();
        if (counter == null) {
            this.cachedCounter.count = 1;
            counterThreadLocal.set(this.cachedCounter);
        } else {
            ++counter.count;
        }
    }

    public boolean inHandler() {
        Counter counter = counterThreadLocal.get();
        if (counter == null) {
            return false;
        }
        if (counter.count == 0) {
            counterThreadLocal.remove();
        }
        return counter.count > 0;
    }

    protected void leave() {
        Counter counter = counterThreadLocal.get();
        if (counter != null && --counter.count <= 0) {
            counterThreadLocal.remove();
        }
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }
    }
}

