/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.group.impl;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.UnproposalListener;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public abstract class GroupHandlingAbstract
implements GroupingHandler {
    protected final Executor executor;
    protected final ManagementService managementService;
    protected final SimpleString address;
    final Set<UnproposalListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public GroupHandlingAbstract(Executor executor, ManagementService managementService, SimpleString address) {
        this.executor = executor;
        this.managementService = managementService;
        this.address = address;
    }

    @Override
    public void addListener(UnproposalListener listener) {
        if (this.executor == null) {
            this.listeners.add(listener);
        } else {
            this.executor.execute(() -> this.listeners.add(listener));
        }
    }

    protected void fireUnproposed(SimpleString groupID) {
        Runnable runnable = () -> {
            for (UnproposalListener listener : this.listeners) {
                listener.unproposed(groupID);
            }
        };
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void forceRemove(SimpleString groupid, SimpleString clusterName) throws Exception {
        this.remove(groupid, clusterName);
        this.sendUnproposal(groupid, clusterName, 0);
    }

    protected void sendUnproposal(SimpleString groupid, SimpleString clusterName, int distance) {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, groupid);
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, clusterName);
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, (NotificationType)CoreNotificationType.UNPROPOSAL, props);
        try {
            this.managementService.sendNotification(notification);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorHandlingMessage(e);
        }
    }
}

