/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.timeline.DataSegment;

public class RetrieveSegmentsByIdAction
implements TaskAction<Set<DataSegment>> {
    private final String dataSource;
    private final Set<String> segmentIds;

    @JsonCreator
    public RetrieveSegmentsByIdAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
        this.dataSource = dataSource;
        this.segmentIds = segmentIds;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Set<String> getSegmentIds() {
        return this.segmentIds;
    }

    @Override
    public TypeReference<Set<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Set<DataSegment>>(){};
    }

    @Override
    public Set<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().retrieveSegmentsById(this.dataSource, this.segmentIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveSegmentsByIdAction that = (RetrieveSegmentsByIdAction)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.segmentIds, that.segmentIds);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.segmentIds);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + "', segmentIds=" + this.segmentIds + "}";
    }
}

