/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Cleaners;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class StupidPool<T>
implements NonBlockingPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    private static final AtomicBoolean POISONED = new AtomicBoolean(false);
    @VisibleForTesting
    final Queue<ObjectResourceHolder> objects = new ConcurrentLinkedQueue<ObjectResourceHolder>();
    @VisibleForTesting
    final AtomicLong poolSize = new AtomicLong(0L);
    private final String name;
    private final Supplier<T> generator;
    private final AtomicLong createdObjectsCounter = new AtomicLong(0L);
    private final AtomicLong leakedObjectsCounter = new AtomicLong(0L);
    private final AtomicReference<CopyOnWriteArrayList<LeakedException>> capturedException = new AtomicReference<Object>(null);
    private final int objectsCacheMaxCount;

    public static boolean isPoisoned() {
        return POISONED.get();
    }

    public StupidPool(String name, Supplier<T> generator) {
        this(name, generator, 0, Integer.MAX_VALUE);
    }

    public StupidPool(String name, Supplier<T> generator, int initCount, int objectsCacheMaxCount) {
        Preconditions.checkArgument((initCount <= objectsCacheMaxCount ? 1 : 0) != 0, (String)"initCount[%s] must be less/equal to objectsCacheMaxCount[%s]", (int)initCount, (int)objectsCacheMaxCount);
        this.name = name;
        this.generator = generator;
        this.objectsCacheMaxCount = objectsCacheMaxCount;
        for (int i = 0; i < initCount; ++i) {
            this.objects.add(this.makeObjectWithHandler());
            this.poolSize.incrementAndGet();
        }
    }

    public String toString() {
        return "StupidPool{name=" + this.name + ", objectsCacheMaxCount=" + this.objectsCacheMaxCount + ", poolSize=" + this.poolSize() + "}";
    }

    @Override
    public ResourceHolder<T> take() {
        ObjectResourceHolder resourceHolder = this.objects.poll();
        if (resourceHolder == null) {
            if (POISONED.get() && this.capturedException.get() != null) {
                throw this.makeExceptionForLeaks(this.capturedException.get());
            }
            return this.makeObjectWithHandler();
        }
        this.poolSize.decrementAndGet();
        if (POISONED.get()) {
            CopyOnWriteArrayList<LeakedException> exceptionList = this.capturedException.get();
            if (exceptionList == null) {
                resourceHolder.notifier.except = new LeakedException(Thread.currentThread().getName());
            } else {
                throw this.makeExceptionForLeaks(exceptionList);
            }
        }
        return resourceHolder;
    }

    private RuntimeException makeExceptionForLeaks(CopyOnWriteArrayList<LeakedException> exceptionList) {
        RuntimeException toThrow = new RuntimeException("Leaks happened, each suppressed exception represents one code path that checked out an object and didn't return it.");
        for (LeakedException exception : exceptionList) {
            toThrow.addSuppressed(exception);
        }
        return toThrow;
    }

    private ObjectResourceHolder makeObjectWithHandler() {
        Object object = this.generator.get();
        this.createdObjectsCounter.incrementAndGet();
        ObjectId objectId = new ObjectId();
        ObjectLeakNotifier notifier = new ObjectLeakNotifier(this, POISONED.get());
        return new ObjectResourceHolder(object, objectId, Cleaners.register(objectId, notifier), notifier);
    }

    @VisibleForTesting
    public long poolSize() {
        return this.poolSize.get();
    }

    @VisibleForTesting
    long leakedObjectsCount() {
        return this.leakedObjectsCounter.get();
    }

    @VisibleForTesting
    public long objectsCreatedCount() {
        return this.createdObjectsCounter.get();
    }

    private void tryReturnToPool(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
        long currentPoolSize;
        notifier.except = null;
        do {
            if ((currentPoolSize = this.poolSize.get()) < (long)this.objectsCacheMaxCount) continue;
            notifier.disable();
            cleanable.clean();
            log.debug("cache num entries is exceeding in [%s], objectId [%s]", this, objectId);
            return;
        } while (!this.poolSize.compareAndSet(currentPoolSize, currentPoolSize + 1L));
        if (!this.objects.offer(new ObjectResourceHolder(object, objectId, cleanable, notifier))) {
            this.impossibleOffsetFailed(object, objectId, cleanable, notifier);
        }
    }

    private void impossibleOffsetFailed(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
        this.poolSize.decrementAndGet();
        notifier.disable();
        cleanable.clean();
        log.error(new ISE("Queue offer failed", new Object[0]), "Could not offer object [%s] back into the queue, objectId [%s]", object, objectId);
    }

    static {
        if (Boolean.parseBoolean(System.getProperty("druid.test.stupidPool.poison"))) {
            POISONED.set(true);
        }
    }

    private static class LeakedException
    extends RuntimeException {
        private final String threadName;

        public LeakedException(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public String getMessage() {
            return StringUtils.format("Originally checked out by thread [%s]", this.threadName);
        }
    }

    private static class ObjectId {
        private ObjectId() {
        }
    }

    private static class ObjectLeakNotifier
    implements Runnable {
        final WeakReference<StupidPool<?>> poolReference;
        final AtomicLong leakedObjectsCounter;
        final AtomicBoolean disabled = new AtomicBoolean(false);
        private LeakedException except;

        ObjectLeakNotifier(StupidPool<?> pool, boolean poisoned) {
            this.poolReference = new WeakReference(pool);
            this.leakedObjectsCounter = pool.leakedObjectsCounter;
            this.except = poisoned ? new LeakedException(Thread.currentThread().getName()) : null;
        }

        @Override
        public void run() {
            try {
                if (!this.disabled.getAndSet(true)) {
                    this.leakedObjectsCounter.incrementAndGet();
                    StupidPool pool = (StupidPool)this.poolReference.get();
                    log.warn("Not closed! Object leaked from %s. Allowing gc to prevent leak.", pool);
                    if (this.except != null && pool != null) {
                        CopyOnWriteArrayList<LeakedException> exceptions = pool.capturedException.get();
                        if (exceptions == null) {
                            pool.capturedException.compareAndSet(null, new CopyOnWriteArrayList());
                        }
                        exceptions = pool.capturedException.get();
                        exceptions.add(this.except);
                        log.error(this.except, "notifier[%s], dumping stack trace from object checkout and poisoning pool", this);
                    }
                }
            }
            catch (Exception e) {
                try {
                    log.error(e, "Exception in ObjectLeakNotifier.run()", new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void disable() {
            this.disabled.set(true);
        }
    }

    class ObjectResourceHolder
    implements ResourceHolder<T> {
        private final AtomicReference<T> objectRef;
        private ObjectId objectId;
        private Cleaners.Cleanable cleanable;
        private ObjectLeakNotifier notifier;

        ObjectResourceHolder(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
            this.objectRef = new AtomicReference(object);
            this.objectId = objectId;
            this.cleanable = cleanable;
            this.notifier = notifier;
        }

        @Override
        public T get() {
            Object object = this.objectRef.get();
            if (object == null) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return object;
        }

        @Override
        public void close() {
            Object object = this.objectRef.get();
            if (object != null && this.objectRef.compareAndSet(object, null)) {
                try {
                    StupidPool.this.tryReturnToPool(object, this.objectId, this.cleanable, this.notifier);
                }
                finally {
                    this.objectId = null;
                    this.cleanable = null;
                    this.notifier = null;
                }
            }
        }

        void forceClean() {
            this.cleanable.clean();
        }
    }
}

