/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.ApplyFunction;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.LambdaExpr;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class FallbackVectorProcessor<T>
implements ExprVectorProcessor<T> {
    final Supplier<ExprEval<?>> fn;
    final List<AdaptedExpr> adaptedArgs;
    private final ExpressionType outputType;

    private FallbackVectorProcessor(Supplier<ExprEval<?>> fn, List<AdaptedExpr> adaptedArgs, ExpressionType outputType) {
        this.fn = fn;
        this.adaptedArgs = adaptedArgs;
        this.outputType = outputType;
    }

    public static <T> FallbackVectorProcessor<T> create(Function function, List<Expr> args, Expr.VectorInputBindingInspector inspector) {
        List<Expr> adaptedArgs = FallbackVectorProcessor.makeAdaptedArgs(args, inspector);
        return FallbackVectorProcessor.makeFallbackProcessor(() -> function.apply(adaptedArgs, UnusedBinding.INSTANCE), adaptedArgs, function.getOutputType(inspector, args), inspector);
    }

    public static <T> FallbackVectorProcessor<T> create(ApplyFunction function, LambdaExpr lambdaExpr, List<Expr> args, Expr.VectorInputBindingInspector inspector) {
        List<Expr> adaptedArgs = FallbackVectorProcessor.makeAdaptedArgs(args, inspector);
        return FallbackVectorProcessor.makeFallbackProcessor(() -> function.apply(lambdaExpr, adaptedArgs, UnusedBinding.INSTANCE), adaptedArgs, function.getOutputType(inspector, lambdaExpr, args), inspector);
    }

    public static <T> FallbackVectorProcessor<T> create(ExprMacroTable.ExprMacro macro, List<Expr> args, Expr.VectorInputBindingInspector inspector) {
        List<Expr> adaptedArgs = FallbackVectorProcessor.makeAdaptedArgs(args, inspector);
        Expr adaptedExpr = macro.apply(adaptedArgs);
        return FallbackVectorProcessor.makeFallbackProcessor(() -> adaptedExpr.eval(UnusedBinding.INSTANCE), adaptedArgs, adaptedExpr.getOutputType(inspector), inspector);
    }

    private static List<Expr> makeAdaptedArgs(List<Expr> args, Expr.VectorInputBindingInspector inspector) {
        ArrayList<Expr> adaptedArgs = new ArrayList<Expr>(args.size());
        for (Expr arg : args) {
            adaptedArgs.add(new AdaptedExpr(arg.asVectorProcessor(inspector), arg));
        }
        return adaptedArgs;
    }

    private static <T> FallbackVectorProcessor<T> makeFallbackProcessor(Supplier<ExprEval<?>> fn, List<Expr> adaptedArgs, ExpressionType outputType, Expr.VectorInputBindingInspector inspector) {
        if (outputType == null) {
            throw DruidException.defensive("Plan has null outputType", new Object[0]);
        }
        if (outputType.equals(ExpressionType.LONG)) {
            return new OfLong(fn, adaptedArgs, outputType, inspector);
        }
        if (outputType.equals(ExpressionType.DOUBLE)) {
            return new OfDouble(fn, adaptedArgs, outputType, inspector);
        }
        return new OfObject(fn, adaptedArgs, outputType, inspector);
    }

    @Override
    public ExpressionType getOutputType() {
        return this.outputType;
    }

    private static class UnusedBinding
    implements Expr.ObjectBinding {
        public static final UnusedBinding INSTANCE = new UnusedBinding();

        private UnusedBinding() {
        }

        @Override
        @Nullable
        public Object get(String name) {
            throw DruidException.defensive("Unexpected binding.get call for field[%s]", name);
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            throw DruidException.defensive("Unexpected binding.getType call for field[%s]", name);
        }
    }

    private static class AdaptedExpr
    implements Expr {
        private final ExprVectorProcessor<?> processor;
        private final Expr originalExpr;
        private final ExpressionType type;
        private ExprEvalVector<?> results;
        private int rowNum;

        public AdaptedExpr(ExprVectorProcessor<?> processor, Expr originalExpr) {
            this.processor = processor;
            this.originalExpr = originalExpr;
            this.type = processor.getOutputType();
        }

        public void populate(Expr.VectorInputBinding vectorBindings) {
            this.results = this.processor.evalVector(vectorBindings);
        }

        public void setRowNumber(int rowNum) {
            this.rowNum = rowNum;
        }

        @Override
        public ExprEval eval(Expr.ObjectBinding bindings) {
            if (this.results == null) {
                return this.originalExpr.eval(bindings);
            }
            if (this.type.is(ExprType.LONG)) {
                boolean isNull = this.results.getNullVector() != null && this.results.getNullVector()[this.rowNum];
                return ExprEval.ofLong(isNull ? null : Long.valueOf(this.results.getLongVector()[this.rowNum]));
            }
            if (this.type.is(ExprType.DOUBLE)) {
                boolean isNull = this.results.getNullVector() != null && this.results.getNullVector()[this.rowNum];
                return ExprEval.ofDouble(isNull ? null : Double.valueOf(this.results.getDoubleVector()[this.rowNum]));
            }
            return ExprEval.ofType(this.type, this.results.getObjectVector()[this.rowNum]);
        }

        @Override
        public String stringify() {
            throw DruidException.defensive("Unexpected call to stringify in fallback processor for expr[%s]", this.originalExpr.stringify());
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            throw DruidException.defensive("Unexpected call to visit in fallback processor for expr[%s]", this.originalExpr.stringify());
        }

        @Override
        public Expr.BindingAnalysis analyzeInputs() {
            return this.originalExpr.analyzeInputs();
        }

        @Override
        public boolean isLiteral() {
            return this.originalExpr.isLiteral();
        }

        @Override
        public boolean isNullLiteral() {
            return this.originalExpr.isNullLiteral();
        }

        @Override
        @Nullable
        public Object getLiteralValue() {
            return this.originalExpr.getLiteralValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdaptedExpr that = (AdaptedExpr)o;
            return Objects.equals(this.originalExpr, that.originalExpr) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.originalExpr, this.type);
        }
    }

    private static class OfDouble
    extends FallbackVectorProcessor<double[]> {
        private final double[] outValues;
        private final boolean[] outNulls;

        public OfDouble(Supplier<ExprEval<?>> fn, List<AdaptedExpr> args, ExpressionType outputType, Expr.VectorInputBindingInspector inspector) {
            super(fn, args, outputType);
            this.outValues = new double[inspector.getMaxVectorSize()];
            this.outNulls = new boolean[inspector.getMaxVectorSize()];
        }

        @Override
        public ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding vectorBindings) {
            for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                adaptedArg.populate(vectorBindings);
            }
            int sz = vectorBindings.getCurrentVectorSize();
            boolean anyNulls = false;
            for (int i = 0; i < sz; ++i) {
                for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                    adaptedArg.setRowNumber(i);
                }
                ExprEval eval = (ExprEval)this.fn.get();
                this.outValues[i] = eval.asDouble();
                this.outNulls[i] = eval.isNumericNull();
                anyNulls = anyNulls || this.outNulls[i];
            }
            return new ExprEvalDoubleVector(this.outValues, anyNulls ? this.outNulls : null);
        }
    }

    private static class OfLong
    extends FallbackVectorProcessor<long[]> {
        private final long[] outValues;
        private final boolean[] outNulls;

        public OfLong(Supplier<ExprEval<?>> fn, List<AdaptedExpr> args, ExpressionType outputType, Expr.VectorInputBindingInspector inspector) {
            super(fn, args, outputType);
            this.outValues = new long[inspector.getMaxVectorSize()];
            this.outNulls = new boolean[inspector.getMaxVectorSize()];
        }

        @Override
        public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding vectorBindings) {
            for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                adaptedArg.populate(vectorBindings);
            }
            int sz = vectorBindings.getCurrentVectorSize();
            boolean anyNulls = false;
            for (int i = 0; i < sz; ++i) {
                for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                    adaptedArg.setRowNumber(i);
                }
                ExprEval eval = (ExprEval)this.fn.get();
                this.outValues[i] = eval.asLong();
                this.outNulls[i] = eval.isNumericNull();
                anyNulls = anyNulls || this.outNulls[i];
            }
            return new ExprEvalLongVector(this.outValues, anyNulls ? this.outNulls : null);
        }
    }

    private static class OfObject
    extends FallbackVectorProcessor<Object[]> {
        private final Object[] outValues;

        public OfObject(Supplier<ExprEval<?>> fn, List<AdaptedExpr> args, ExpressionType outputType, Expr.VectorInputBindingInspector inspector) {
            super(fn, args, outputType);
            this.outValues = new Object[inspector.getMaxVectorSize()];
        }

        @Override
        public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding vectorBindings) {
            for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                adaptedArg.populate(vectorBindings);
            }
            int sz = vectorBindings.getCurrentVectorSize();
            for (int i = 0; i < sz; ++i) {
                for (AdaptedExpr adaptedArg : this.adaptedArgs) {
                    adaptedArg.setRowNumber(i);
                }
                this.outValues[i] = ((ExprEval)this.fn.get()).value();
            }
            return new ExprEvalObjectVector(this.outValues, this.getOutputType());
        }
    }
}

