/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.segment.SegmentReference;

@JsonTypeName(value="query")
public class QueryDataSource
implements DataSource {
    @JsonProperty
    private final Query<?> query;

    @JsonCreator
    public QueryDataSource(@JsonProperty(value="query") Query query) {
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"'query' must be nonnull");
    }

    @Override
    public Set<String> getTableNames() {
        HashSet<String> names = new HashSet<String>();
        for (DataSource ds : this.getQueryDataSources()) {
            names.addAll(ds.getTableNames());
        }
        return names;
    }

    @JsonProperty
    public Query getQuery() {
        return this.query;
    }

    @Override
    public List<DataSource> getChildren() {
        return this.getQueryDataSources();
    }

    private List<DataSource> getQueryDataSources() {
        if (this.query instanceof UnionQuery) {
            return ((UnionQuery)this.query).getDataSources();
        }
        return Collections.singletonList(this.query.getDataSource());
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (this.query instanceof UnionQuery) {
            return new QueryDataSource(((UnionQuery)this.query).withDataSources(children));
        }
        if (children.size() != 1) {
            throw new IAE("Must have exactly one child", new Object[0]);
        }
        return new QueryDataSource(this.query.withDataSource(children.get(0)));
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.query.getDataSource().isGlobal();
    }

    @Override
    public boolean isConcrete() {
        return false;
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTime) {
        Query subQuery = this.getQuery();
        return subQuery.getDataSource().createSegmentMapFunction(subQuery, cpuTime);
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return new QueryDataSource(this.query.withDataSource(this.query.getDataSource().withUpdatedDataSource(newSource)));
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        Query subQuery = this.getQuery();
        return subQuery.getDataSourceAnalysis();
    }

    public String toString() {
        return this.query.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDataSource that = (QueryDataSource)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }
}

