/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ExpressionPostAggregator
implements PostAggregator {
    private static final Comparator<Comparable> DEFAULT_COMPARATOR = Comparator.nullsFirst((o1, o2) -> {
        if (o1 instanceof Long && o2 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return Double.compare(((Number)((Object)o1)).doubleValue(), ((Number)((Object)o2)).doubleValue());
        }
        return o1.compareTo(o2);
    });
    private final String name;
    private final String expression;
    private final Comparator<Comparable> comparator;
    @Nullable
    private final String ordering;
    private final Map<String, Function<Object, Object>> finalizers;
    private final Expr.InputBindingInspector partialTypeInformation;
    private final Supplier<Expr> parsed;
    private final Supplier<Set<String>> dependentFields;
    private final Supplier<byte[]> cacheKey;
    @Nullable
    private final ColumnType outputType;
    @Nullable
    private final ExpressionType expressionType;

    @JsonCreator
    public ExpressionPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="ordering") @Nullable String ordering, @JsonProperty(value="outputType") @Nullable ColumnType outputType, @JacksonInject ExprMacroTable macroTable) {
        this(name, expression, ordering, outputType, Parser.lazyParse(expression, macroTable));
    }

    public ExpressionPostAggregator(String name, String expression, @Nullable String ordering, @Nullable ColumnType outputType, Expr parsed) {
        this(name, expression, ordering, outputType, (Supplier<Expr>)((Supplier)() -> parsed));
    }

    private ExpressionPostAggregator(String name, String expression, @Nullable String ordering, @Nullable ColumnType outputType, Supplier<Expr> parsed) {
        this(name, expression, ordering, outputType, (Map<String, Function<Object, Object>>)ImmutableMap.of(), InputBindings.nilBindings(), parsed, (Supplier<Set<String>>)Suppliers.memoize(() -> ((Expr)parsed.get()).analyzeInputs().getRequiredBindings()));
    }

    private ExpressionPostAggregator(String name, String expression, @Nullable String ordering, @Nullable ColumnType outputType, Map<String, Function<Object, Object>> finalizers, Expr.InputBindingInspector partialTypeInformation, Supplier<Expr> parsed, Supplier<Set<String>> dependentFields) {
        Preconditions.checkArgument((expression != null ? 1 : 0) != 0, (Object)"expression cannot be null");
        this.name = name;
        this.expression = expression;
        this.ordering = ordering;
        this.outputType = outputType;
        ExpressionType expressionType = this.expressionType = outputType != null ? ExpressionType.fromColumnTypeStrict(outputType) : null;
        this.comparator = outputType != null && ordering == null ? outputType.getNullableStrategy() : (ordering == null ? DEFAULT_COMPARATOR : Ordering.valueOf(ordering));
        this.finalizers = finalizers;
        this.partialTypeInformation = partialTypeInformation;
        this.parsed = parsed;
        this.dependentFields = dependentFields;
        this.cacheKey = Suppliers.memoize(() -> new CacheKeyBuilder(4).appendCacheable((Cacheable)parsed.get()).appendString(ordering).appendString(outputType != null ? outputType.asTypeString() : null).build());
    }

    @Override
    public Set<String> getDependentFields() {
        return (Set)this.dependentFields.get();
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Map finalizedValues = Maps.transformEntries(values, (k, v) -> {
            Function<Object, Object> finalizer = this.finalizers.get(k);
            return finalizer != null ? finalizer.apply(v) : v;
        });
        ExprEval eval = ((Expr)this.parsed.get()).eval(InputBindings.forMap(finalizedValues, this.partialTypeInformation));
        if (this.expressionType == null) {
            return eval.valueOrDefault();
        }
        if (this.outputType.is(ValueType.FLOAT) && !eval.isNumericNull()) {
            return Float.valueOf((float)eval.asDouble());
        }
        if (eval.type().equals(this.expressionType)) {
            return eval.valueOrDefault();
        }
        if (this.expressionType.is(ExprType.STRING) && eval.isArray()) {
            return ExpressionSelectors.coerceEvalToObjectOrList(eval);
        }
        return eval.castTo(this.expressionType).valueOrDefault();
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        if (this.outputType != null) {
            return this.outputType;
        }
        ExpressionType type = ((Expr)this.parsed.get()).getOutputType(signature);
        if (type == null) {
            return null;
        }
        return ExpressionType.toColumnType(type);
    }

    @Override
    public ExpressionPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        HashMap finalizers = Maps.newHashMapWithExpectedSize((int)aggregators.size());
        HashMap types = Maps.newHashMapWithExpectedSize((int)aggregators.size());
        for (Map.Entry<String, AggregatorFactory> factory : aggregators.entrySet()) {
            finalizers.put(factory.getKey(), factory.getValue()::finalizeComputation);
            types.put(factory.getKey(), ExpressionType.fromColumnType(factory.getValue().getResultType()));
        }
        return new ExpressionPostAggregator(this.name, this.expression, this.ordering, this.outputType, finalizers, InputBindings.inspectorFromTypeMap(types), this.parsed, this.dependentFields);
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    @JsonProperty(value="ordering")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrdering() {
        return this.ordering;
    }

    @Nullable
    @JsonProperty(value="outputType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ColumnType getOutputType() {
        return this.outputType;
    }

    public String toString() {
        return "ExpressionPostAggregator{name='" + this.name + "', expression='" + this.expression + "', ordering=" + this.ordering + ", outputType=" + this.outputType + "}";
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionPostAggregator that = (ExpressionPostAggregator)o;
        if (!this.comparator.equals(that.comparator)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        if (!Objects.equals(this.ordering, that.ordering)) {
            return false;
        }
        return Objects.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.comparator, this.ordering, this.outputType);
    }

    public static enum Ordering implements Comparator<Comparable>
    {
        numericFirst{

            @Override
            public int compare(Comparable lhs, Comparable rhs) {
                if (lhs instanceof Long && rhs instanceof Long) {
                    return Long.compare(((Number)((Object)lhs)).longValue(), ((Number)((Object)rhs)).longValue());
                }
                if (lhs instanceof Number && rhs instanceof Number) {
                    double d1 = ((Number)((Object)lhs)).doubleValue();
                    double d2 = ((Number)((Object)rhs)).doubleValue();
                    if (Double.isFinite(d1) && !Double.isFinite(d2)) {
                        return 1;
                    }
                    if (!Double.isFinite(d1) && Double.isFinite(d2)) {
                        return -1;
                    }
                    return Double.compare(d1, d2);
                }
                return Comparators.naturalNullsFirst().compare((Object)lhs, (Object)rhs);
            }
        };

    }
}

