/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.ExprUtils;

public class TimestampCeilExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_ceil";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 4);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampCeilExpr(this, args);
        }
        return new TimestampCeilDynamicExpr(this, args);
    }

    private static PeriodGranularity getGranularity(Expr expr, List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(expr, args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    @VisibleForTesting
    static class TimestampCeilDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampCeilDynamicExpr(TimestampCeilExprMacro macro, List<Expr> args) {
            super(macro, args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            long bucketStartTime;
            PeriodGranularity granularity = TimestampCeilExprMacro.getGranularity(this, this.args, bindings);
            long argTime = ((Expr)this.args.get(0)).eval(bindings).asLong();
            if (argTime == (bucketStartTime = granularity.bucketStart(argTime))) {
                return ExprEval.of(bucketStartTime);
            }
            return ExprEval.of(granularity.increment(bucketStartTime));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }

    @VisibleForTesting
    static class TimestampCeilExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Granularity granularity;

        TimestampCeilExpr(TimestampCeilExprMacro macro, List<Expr> args) {
            super(macro, args);
            this.granularity = TimestampCeilExprMacro.getGranularity(this, args, InputBindings.nilBindings());
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            long bucketStartTime;
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            long argTime = eval.asLong();
            if (argTime == (bucketStartTime = this.granularity.bucketStart(argTime))) {
                return ExprEval.of(bucketStartTime);
            }
            return ExprEval.of(this.granularity.increment(bucketStartTime));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TimestampCeilExpr that = (TimestampCeilExpr)o;
            return Objects.equals(this.granularity, that.granularity);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.granularity);
        }
    }
}

