/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BaseTypeSignature;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseFloatVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class NestedFieldVirtualColumn
implements VirtualColumn {
    private final String outputName;
    private final NestedFieldSpec fieldSpec;
    private final boolean hasNegativeArrayIndex;

    @JsonCreator
    public NestedFieldVirtualColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="expectedType") @Nullable ColumnType expectedType, @JsonProperty(value="pathParts") @Nullable List<NestedPathPart> parts, @JsonProperty(value="processFromRaw") @Nullable Boolean processFromRaw, @JsonProperty(value="path") @Nullable String path, @JsonProperty(value="useJqSyntax") @Nullable Boolean useJqSyntax) {
        List<NestedPathPart> pathParts;
        this.outputName = outputName;
        if (path != null) {
            Preconditions.checkArgument((parts == null ? 1 : 0) != 0, (Object)"Cannot define both 'path' and 'pathParts'");
        } else if (parts == null) {
            throw new IllegalArgumentException("Must define exactly one of 'path' or 'pathParts'");
        }
        if (parts != null) {
            pathParts = parts;
        } else {
            boolean isInputJq = useJqSyntax != null && useJqSyntax != false;
            pathParts = isInputJq ? NestedPathFinder.parseJqPath(path) : NestedPathFinder.parseJsonPath(path);
        }
        boolean hasNegative = false;
        for (NestedPathPart part : pathParts) {
            NestedPathArrayElement elementPart;
            if (!(part instanceof NestedPathArrayElement) || (elementPart = (NestedPathArrayElement)part).getIndex() >= 0) continue;
            hasNegative = true;
            break;
        }
        this.hasNegativeArrayIndex = hasNegative;
        this.fieldSpec = new NestedFieldSpec(columnName, expectedType, pathParts, processFromRaw != null && processFromRaw != false);
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName) {
        this(columnName, outputName, null, null, null, path, false);
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName, @Nullable ColumnType expectedType) {
        this(columnName, outputName, expectedType, null, null, path, false);
    }

    @Override
    public byte[] getCacheKey() {
        String partsString = NestedPathFinder.toNormalizedJsonPath(this.fieldSpec.parts);
        return new CacheKeyBuilder(-1).appendString("nested-field").appendString(this.outputName).appendString(this.fieldSpec.columnName).appendString(partsString).appendBoolean(this.fieldSpec.processFromRaw).build();
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @JsonProperty
    public String getColumnName() {
        return this.fieldSpec.columnName;
    }

    @JsonProperty(value="pathParts")
    public List<NestedPathPart> getPathParts() {
        return this.fieldSpec.parts;
    }

    @JsonProperty
    public ColumnType getExpectedType() {
        return this.fieldSpec.expectedType;
    }

    @JsonProperty
    public boolean isProcessFromRaw() {
        return this.fieldSpec.processFromRaw;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        ColumnValueSelector<?> valueSelector = this.makeColumnValueSelector(dimensionSpec.getOutputName(), factory);
        return dimensionSpec.decorate(new FieldDimensionSelector(valueSelector));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        ColumnValueSelector baseSelector = factory.makeColumnValueSelector(this.fieldSpec.columnName);
        return this.fieldSpec.processFromRaw ? new RawFieldColumnSelector(baseSelector, this.fieldSpec.parts) : new RawFieldLiteralColumnValueSelector(baseSelector, this.fieldSpec.parts);
    }

    @Override
    @Nullable
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return dimensionSpec.decorate(DimensionSelector.constant(null, dimensionSpec.getExtractionFn()));
        }
        if (this.hasNegativeArrayIndex) {
            return null;
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(holder, offset, dimensionSpec.getExtractionFn()));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(ColumnHolder holder, ReadableOffset offset, @Nullable ExtractionFn extractionFn) {
        BaseColumn theColumn = holder.getColumn();
        if (theColumn instanceof NestedDataComplexColumn) {
            NestedDataComplexColumn column = (NestedDataComplexColumn)theColumn;
            return column.makeDimensionSelector(this.fieldSpec.parts, offset, extractionFn);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            if (theColumn instanceof DictionaryEncodedColumn) {
                DictionaryEncodedColumn column = (DictionaryEncodedColumn)theColumn;
                return new BestEffortCastingValueSelector(column.makeDimensionSelector(offset, extractionFn));
            }
            return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)holder.getCapabilities().getType(), theColumn.makeColumnValueSelector(offset), extractionFn);
        }
        if (this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && theColumn instanceof VariantColumn) {
            VariantColumn arrayColumn = (VariantColumn)theColumn;
            final ColumnValueSelector<?> arraySelector = arrayColumn.makeColumnValueSelector(offset);
            final int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new BaseSingleValueDimensionSelector(){

                @Override
                @Nullable
                protected String getValue() {
                    Object[] array;
                    Object o = arraySelector.getObject();
                    if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                        Object element = array[elementNumber];
                        if (element == null) {
                            return null;
                        }
                        return String.valueOf(element);
                    }
                    return null;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    arraySelector.inspectRuntimeShape(inspector);
                }
            };
        }
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    @Nullable
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilColumnValueSelector.instance();
        }
        BaseColumn theColumn = holder.getColumn();
        if (this.fieldSpec.processFromRaw || this.hasNegativeArrayIndex) {
            return null;
        }
        if (theColumn instanceof NestedDataComplexColumn) {
            NestedDataComplexColumn column = (NestedDataComplexColumn)theColumn;
            return column.makeColumnValueSelector(this.fieldSpec.parts, offset);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            if (theColumn instanceof DictionaryEncodedColumn && !(theColumn instanceof VariantColumn)) {
                DictionaryEncodedColumn column = (DictionaryEncodedColumn)theColumn;
                return new BestEffortCastingValueSelector(column.makeDimensionSelector(offset, null));
            }
            return theColumn.makeColumnValueSelector(offset);
        }
        if (this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && theColumn instanceof VariantColumn) {
            VariantColumn arrayColumn = (VariantColumn)theColumn;
            final ColumnValueSelector<?> arraySelector = arrayColumn.makeColumnValueSelector(offset);
            final int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new ColumnValueSelector<Object>(){

                @Override
                public boolean isNull() {
                    Object o = this.getObject();
                    return !(o instanceof Number);
                }

                @Override
                public long getLong() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).longValue() : 0L;
                }

                @Override
                public float getFloat() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).floatValue() : 0.0f;
                }

                @Override
                public double getDouble() {
                    Object o = this.getObject();
                    return o instanceof Number ? ((Number)o).doubleValue() : 0.0;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    arraySelector.inspectRuntimeShape(inspector);
                }

                @Override
                @Nullable
                public Object getObject() {
                    Object[] array;
                    Object o = arraySelector.getObject();
                    if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                        return array[elementNumber];
                    }
                    return null;
                }

                @Override
                public Class<?> classOfObject() {
                    return Object.class;
                }
            };
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        return !this.hasNegativeArrayIndex;
    }

    @Override
    @Nullable
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return dimensionSpec.decorate(NilVectorSelector.create(offset));
        }
        return dimensionSpec.decorate(this.makeSingleValueVectorDimensionSelectorUndecorated(holder, offset));
    }

    private SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelectorUndecorated(ColumnHolder holder, ReadableVectorOffset offset) {
        BaseColumn theColumn = holder.getColumn();
        if (theColumn instanceof NestedDataComplexColumn) {
            NestedDataComplexColumn column = (NestedDataComplexColumn)theColumn;
            return column.makeSingleValueDimensionVectorSelector(this.fieldSpec.parts, offset);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            return ((DictionaryEncodedColumn)theColumn).makeSingleValueDimensionVectorSelector(offset);
        }
        return NilVectorSelector.create(offset);
    }

    @Override
    @Nullable
    public VectorObjectSelector makeVectorObjectSelector(String columnName, ColumnSelector columnSelector, final ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilVectorSelector.create(offset);
        }
        BaseColumn column = holder.getColumn();
        if (column instanceof NestedDataComplexColumn) {
            NestedDataComplexColumn complexColumn = (NestedDataComplexColumn)column;
            if (this.fieldSpec.processFromRaw) {
                return new RawFieldVectorObjectSelector(complexColumn.makeVectorObjectSelector(offset), this.fieldSpec.parts);
            }
            Set<ColumnType> types = complexColumn.getColumnTypes(this.fieldSpec.parts);
            TypeSignature leastRestrictiveType = null;
            if (types != null) {
                for (ColumnType type : types) {
                    leastRestrictiveType = ColumnType.leastRestrictiveType((ColumnType)leastRestrictiveType, type);
                }
            }
            if (leastRestrictiveType != null && leastRestrictiveType.isNumeric() && !Types.isNumeric(this.fieldSpec.expectedType)) {
                return ExpressionVectorSelectors.castValueSelectorToObject(offset, columnName, complexColumn.makeVectorValueSelector(this.fieldSpec.parts, offset), (ColumnType)leastRestrictiveType, this.fieldSpec.expectedType == null ? ColumnType.STRING : this.fieldSpec.expectedType);
            }
            VectorObjectSelector objectSelector = complexColumn.makeVectorObjectSelector(this.fieldSpec.parts, offset);
            if (leastRestrictiveType != null && leastRestrictiveType.isArray() && this.fieldSpec.expectedType != null && !this.fieldSpec.expectedType.isArray()) {
                ExpressionType elementType = ExpressionType.fromColumnTypeStrict(((BaseTypeSignature)leastRestrictiveType).getElementType());
                ExpressionType castTo = ExpressionType.fromColumnTypeStrict(this.fieldSpec.expectedType);
                return NestedFieldVirtualColumn.makeVectorArrayToScalarObjectSelector(offset, objectSelector, elementType, castTo);
            }
            return objectSelector;
        }
        if (this.fieldSpec.parts.isEmpty()) {
            ColumnCapabilities capabilities = holder.getCapabilities();
            Preconditions.checkArgument((this.fieldSpec.expectedType != null ? 1 : 0) != 0, (Object)"Asked for a VectorObjectSelector on a numeric column, 'expectedType' must not be null");
            if (capabilities.isNumeric()) {
                return ExpressionVectorSelectors.castValueSelectorToObject(offset, this.fieldSpec.columnName, column.makeVectorValueSelector(offset), capabilities.toColumnType(), this.fieldSpec.expectedType);
            }
            if (capabilities.isArray() && !this.fieldSpec.expectedType.isArray()) {
                VectorObjectSelector delegate = column.makeVectorObjectSelector(offset);
                ExpressionType elementType = ExpressionType.fromColumnTypeStrict(capabilities.getElementType());
                ExpressionType castTo = ExpressionType.fromColumnTypeStrict(this.fieldSpec.expectedType);
                return NestedFieldVirtualColumn.makeVectorArrayToScalarObjectSelector(offset, delegate, elementType, castTo);
            }
            return column.makeVectorObjectSelector(offset);
        }
        if (this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && column instanceof VariantColumn) {
            VariantColumn arrayColumn = (VariantColumn)column;
            final ExpressionType elementType = ExpressionType.fromColumnTypeStrict(arrayColumn.getLogicalType().isArray() ? arrayColumn.getLogicalType().getElementType() : arrayColumn.getLogicalType());
            final ExpressionType castTo = this.fieldSpec.expectedType == null ? ExpressionType.STRING : ExpressionType.fromColumnTypeStrict(this.fieldSpec.expectedType);
            final VectorObjectSelector arraySelector = arrayColumn.makeVectorObjectSelector(offset);
            final int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new VectorObjectSelector(){
                private final Object[] elements;
                private int id;
                {
                    this.elements = new Object[arraySelector.getMaxVectorSize()];
                    this.id = -1;
                }

                @Override
                public Object[] getObjectVector() {
                    if (offset.getId() != this.id) {
                        Object[] delegate = arraySelector.getObjectVector();
                        for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                            Object maybeArray = delegate[i];
                            if (maybeArray instanceof Object[]) {
                                Object[] anArray = (Object[])maybeArray;
                                if (elementNumber < anArray.length) {
                                    this.elements[i] = ExprEval.ofType(elementType, anArray[elementNumber]).castTo(castTo).value();
                                    continue;
                                }
                                this.elements[i] = null;
                                continue;
                            }
                            this.elements[i] = null;
                        }
                        this.id = offset.getId();
                    }
                    return this.elements;
                }

                @Override
                public int getMaxVectorSize() {
                    return arraySelector.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return arraySelector.getCurrentVectorSize();
                }
            };
        }
        return NilVectorSelector.create(offset);
    }

    @Override
    @Nullable
    public VectorValueSelector makeVectorValueSelector(String columnName, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilVectorSelector.create(offset);
        }
        BaseColumn theColumn = holder.getColumn();
        if (!(theColumn instanceof NestedDataComplexColumn)) {
            if (this.fieldSpec.parts.isEmpty()) {
                if (theColumn instanceof DictionaryEncodedColumn) {
                    final VectorObjectSelector delegate = theColumn.makeVectorObjectSelector(offset);
                    if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.LONG)) {
                        return new BaseLongVectorValueSelector(offset){
                            private int currentOffsetId;
                            private final long[] longs;
                            @Nullable
                            private boolean[] nulls;
                            {
                                super(offset);
                                this.currentOffsetId = -1;
                                this.longs = new long[delegate.getMaxVectorSize()];
                                this.nulls = null;
                            }

                            @Override
                            public long[] getLongVector() {
                                this.computeLongs();
                                return this.longs;
                            }

                            @Override
                            @Nullable
                            public boolean[] getNullVector() {
                                this.computeLongs();
                                return this.nulls;
                            }

                            private void computeLongs() {
                                if (this.currentOffsetId != this.offset.getId()) {
                                    this.currentOffsetId = this.offset.getId();
                                    Object[] values = delegate.getObjectVector();
                                    for (int i = 0; i < values.length; ++i) {
                                        Number n = ExprEval.computeNumber(Evals.asString(values[i]));
                                        if (n != null) {
                                            this.longs[i] = n.longValue();
                                            if (this.nulls == null) continue;
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        if (this.nulls == null) {
                                            this.nulls = new boolean[this.offset.getMaxVectorSize()];
                                        }
                                        this.nulls[i] = true;
                                    }
                                }
                            }
                        };
                    }
                    if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.FLOAT)) {
                        return new BaseFloatVectorValueSelector(offset){
                            private int currentOffsetId;
                            private final float[] floats;
                            @Nullable
                            private boolean[] nulls;
                            {
                                super(offset);
                                this.currentOffsetId = -1;
                                this.floats = new float[delegate.getMaxVectorSize()];
                                this.nulls = null;
                            }

                            @Override
                            public float[] getFloatVector() {
                                this.computeFloats();
                                return this.floats;
                            }

                            @Override
                            @Nullable
                            public boolean[] getNullVector() {
                                this.computeFloats();
                                return this.nulls;
                            }

                            private void computeFloats() {
                                if (this.currentOffsetId != this.offset.getId()) {
                                    this.currentOffsetId = this.offset.getId();
                                    Object[] values = delegate.getObjectVector();
                                    for (int i = 0; i < values.length; ++i) {
                                        Number n = ExprEval.computeNumber(Evals.asString(values[i]));
                                        if (n != null) {
                                            this.floats[i] = n.floatValue();
                                            if (this.nulls == null) continue;
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        if (this.nulls == null) {
                                            this.nulls = new boolean[this.offset.getMaxVectorSize()];
                                        }
                                        this.nulls[i] = true;
                                    }
                                }
                            }
                        };
                    }
                    return new BaseDoubleVectorValueSelector(offset){
                        private int currentOffsetId;
                        private final double[] doubles;
                        @Nullable
                        private boolean[] nulls;
                        {
                            super(offset);
                            this.currentOffsetId = -1;
                            this.doubles = new double[delegate.getMaxVectorSize()];
                            this.nulls = null;
                        }

                        @Override
                        public double[] getDoubleVector() {
                            this.computeDoubles();
                            return this.doubles;
                        }

                        @Override
                        @Nullable
                        public boolean[] getNullVector() {
                            this.computeDoubles();
                            return this.nulls;
                        }

                        private void computeDoubles() {
                            if (this.currentOffsetId != this.offset.getId()) {
                                this.currentOffsetId = this.offset.getId();
                                Object[] values = delegate.getObjectVector();
                                for (int i = 0; i < values.length; ++i) {
                                    Number n = ExprEval.computeNumber(Evals.asString(values[i]));
                                    if (n != null) {
                                        this.doubles[i] = n.doubleValue();
                                        if (this.nulls == null) continue;
                                        this.nulls[i] = false;
                                        continue;
                                    }
                                    if (this.nulls == null) {
                                        this.nulls = new boolean[this.offset.getMaxVectorSize()];
                                    }
                                    this.nulls[i] = true;
                                }
                            }
                        }
                    };
                }
                return theColumn.makeVectorValueSelector(offset);
            }
            if (this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && theColumn instanceof VariantColumn) {
                VariantColumn arrayColumn = (VariantColumn)theColumn;
                final VectorObjectSelector arraySelector = arrayColumn.makeVectorObjectSelector(offset);
                final int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
                if (elementNumber < 0) {
                    throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
                }
                if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.LONG)) {
                    return new BaseLongVectorValueSelector(offset){
                        private final long[] longs;
                        private final boolean[] nulls;
                        private int id;
                        {
                            super(offset);
                            this.longs = new long[this.offset.getMaxVectorSize()];
                            this.nulls = new boolean[this.offset.getMaxVectorSize()];
                            this.id = -1;
                        }

                        private void computeNumbers() {
                            if (this.offset.getId() != this.id) {
                                Object[] maybeArrays = arraySelector.getObjectVector();
                                for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                                    Object maybeArray = maybeArrays[i];
                                    if (maybeArray instanceof Object[]) {
                                        Object[] anArray = (Object[])maybeArray;
                                        if (elementNumber < anArray.length) {
                                            Double d;
                                            if (anArray[elementNumber] instanceof Number) {
                                                Number n = (Number)anArray[elementNumber];
                                                this.longs[i] = n.longValue();
                                                this.nulls[i] = false;
                                                continue;
                                            }
                                            Double d2 = d = anArray[elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[elementNumber])) : null;
                                            if (d != null) {
                                                this.longs[i] = d.longValue();
                                                this.nulls[i] = false;
                                                continue;
                                            }
                                            this.longs[i] = 0L;
                                            this.nulls[i] = true;
                                            continue;
                                        }
                                        this.nullElement(i);
                                        continue;
                                    }
                                    this.nullElement(i);
                                }
                                this.id = this.offset.getId();
                            }
                        }

                        private void nullElement(int i) {
                            this.longs[i] = 0L;
                            this.nulls[i] = true;
                        }

                        @Override
                        public long[] getLongVector() {
                            if (this.offset.getId() != this.id) {
                                this.computeNumbers();
                            }
                            return this.longs;
                        }

                        @Override
                        @Nullable
                        public boolean[] getNullVector() {
                            if (this.offset.getId() != this.id) {
                                this.computeNumbers();
                            }
                            return this.nulls;
                        }
                    };
                }
                if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.FLOAT)) {
                    return new BaseFloatVectorValueSelector(offset){
                        private final float[] floats;
                        private final boolean[] nulls;
                        private int id;
                        {
                            super(offset);
                            this.floats = new float[this.offset.getMaxVectorSize()];
                            this.nulls = new boolean[this.offset.getMaxVectorSize()];
                            this.id = -1;
                        }

                        private void computeNumbers() {
                            if (this.offset.getId() != this.id) {
                                Object[] maybeArrays = arraySelector.getObjectVector();
                                for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                                    Object maybeArray = maybeArrays[i];
                                    if (maybeArray instanceof Object[]) {
                                        Object[] anArray = (Object[])maybeArray;
                                        if (elementNumber < anArray.length) {
                                            Double d;
                                            if (anArray[elementNumber] instanceof Number) {
                                                Number n = (Number)anArray[elementNumber];
                                                this.floats[i] = n.floatValue();
                                                this.nulls[i] = false;
                                                continue;
                                            }
                                            Double d2 = d = anArray[elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[elementNumber])) : null;
                                            if (d != null) {
                                                this.floats[i] = d.floatValue();
                                                this.nulls[i] = false;
                                                continue;
                                            }
                                            this.nullElement(i);
                                            continue;
                                        }
                                        this.nullElement(i);
                                        continue;
                                    }
                                    this.nullElement(i);
                                }
                                this.id = this.offset.getId();
                            }
                        }

                        private void nullElement(int i) {
                            this.floats[i] = 0.0f;
                            this.nulls[i] = true;
                        }

                        @Override
                        public float[] getFloatVector() {
                            if (this.offset.getId() != this.id) {
                                this.computeNumbers();
                            }
                            return this.floats;
                        }

                        @Override
                        @Nullable
                        public boolean[] getNullVector() {
                            if (this.offset.getId() != this.id) {
                                this.computeNumbers();
                            }
                            return this.nulls;
                        }
                    };
                }
                return new BaseDoubleVectorValueSelector(offset){
                    private final double[] doubles;
                    private final boolean[] nulls;
                    private int id;
                    {
                        super(offset);
                        this.doubles = new double[this.offset.getMaxVectorSize()];
                        this.nulls = new boolean[this.offset.getMaxVectorSize()];
                        this.id = -1;
                    }

                    private void computeNumbers() {
                        if (this.offset.getId() != this.id) {
                            Object[] maybeArrays = arraySelector.getObjectVector();
                            for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                                Object maybeArray = maybeArrays[i];
                                if (maybeArray instanceof Object[]) {
                                    Object[] anArray = (Object[])maybeArray;
                                    if (elementNumber < anArray.length) {
                                        Double d;
                                        if (anArray[elementNumber] instanceof Number) {
                                            Number n = (Number)anArray[elementNumber];
                                            this.doubles[i] = n.doubleValue();
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        Double d2 = d = anArray[elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[elementNumber])) : null;
                                        if (d != null) {
                                            this.doubles[i] = d;
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        this.nullElement(i);
                                        continue;
                                    }
                                    this.nullElement(i);
                                    continue;
                                }
                                this.nullElement(i);
                            }
                            this.id = this.offset.getId();
                        }
                    }

                    private void nullElement(int i) {
                        this.doubles[i] = 0.0;
                        this.nulls[i] = true;
                    }

                    @Override
                    public double[] getDoubleVector() {
                        if (this.offset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.doubles;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        if (this.offset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.nulls;
                    }
                };
            }
            return NilVectorSelector.create(offset);
        }
        NestedDataComplexColumn column = (NestedDataComplexColumn)theColumn;
        if (column.isNumeric(this.fieldSpec.parts) || this.fieldSpec.expectedType == null) {
            return column.makeVectorValueSelector(this.fieldSpec.parts, offset);
        }
        final VectorObjectSelector objectSelector = column.makeVectorObjectSelector(this.fieldSpec.parts, offset);
        if (this.fieldSpec.expectedType.is(ValueType.LONG)) {
            return new BaseLongVectorValueSelector(offset){
                private final long[] longVector;
                @Nullable
                private boolean[] nullVector;
                private int id;
                {
                    super(offset);
                    this.longVector = new long[this.offset.getMaxVectorSize()];
                    this.nullVector = null;
                    this.id = -1;
                }

                @Override
                public long[] getLongVector() {
                    this.computeVectorsIfNeeded();
                    return this.longVector;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    this.id = this.offset.getId();
                    Object[] vals = objectSelector.getObjectVector();
                    for (int i = 0; i < objectSelector.getCurrentVectorSize(); ++i) {
                        Long l;
                        Object v = vals[i];
                        if (v == null) {
                            if (this.nullVector == null) {
                                this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                            }
                            this.longVector[i] = 0L;
                            this.nullVector[i] = true;
                            continue;
                        }
                        if (v instanceof Number) {
                            l = ((Number)v).longValue();
                        } else {
                            Double d;
                            String s = String.valueOf(v);
                            l = GuavaUtils.tryParseLong(s);
                            if (l == null && (d = Doubles.tryParse((String)s)) != null) {
                                l = d.longValue();
                            }
                        }
                        if (l != null) {
                            this.longVector[i] = l;
                            if (this.nullVector == null) continue;
                            this.nullVector[i] = false;
                            continue;
                        }
                        if (this.nullVector == null) {
                            this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                        }
                        this.longVector[i] = 0L;
                        this.nullVector[i] = true;
                    }
                }
            };
        }
        return new BaseDoubleVectorValueSelector(offset){
            private final double[] doubleVector;
            @Nullable
            private boolean[] nullVector;
            private int id;
            {
                super(offset);
                this.doubleVector = new double[this.offset.getMaxVectorSize()];
                this.nullVector = null;
                this.id = -1;
            }

            @Override
            public double[] getDoubleVector() {
                this.computeVectorsIfNeeded();
                return this.doubleVector;
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                this.computeVectorsIfNeeded();
                return this.nullVector;
            }

            private void computeVectorsIfNeeded() {
                if (this.id == this.offset.getId()) {
                    return;
                }
                this.id = this.offset.getId();
                Object[] vals = objectSelector.getObjectVector();
                for (int i = 0; i < objectSelector.getCurrentVectorSize(); ++i) {
                    Object v = vals[i];
                    if (v == null) {
                        if (this.nullVector == null) {
                            this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                        }
                        this.doubleVector[i] = 0.0;
                        this.nullVector[i] = true;
                        continue;
                    }
                    Double d = v instanceof Number ? Double.valueOf(((Number)v).doubleValue()) : Doubles.tryParse((String)String.valueOf(v));
                    if (d != null) {
                        this.doubleVector[i] = d;
                        if (this.nullVector == null) continue;
                        this.nullVector[i] = false;
                        continue;
                    }
                    if (this.nullVector == null) {
                        this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                    }
                    this.doubleVector[i] = 0.0;
                    this.nullVector[i] = true;
                }
            }
        };
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector indexSelector) {
        ColumnHolder holder = indexSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return null;
        }
        BaseColumn theColumn = holder.getColumn();
        if (theColumn instanceof CompressedNestedDataComplexColumn) {
            CompressedNestedDataComplexColumn nestedColumn = (CompressedNestedDataComplexColumn)theColumn;
            ColumnIndexSupplier nestedColumnPathIndexSupplier = nestedColumn.getColumnIndexSupplier(this.fieldSpec.parts);
            if (nestedColumnPathIndexSupplier == null && this.fieldSpec.processFromRaw) {
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            if (this.fieldSpec.expectedType != null) {
                Set<ColumnType> types = nestedColumn.getColumnTypes(this.fieldSpec.parts);
                if (this.fieldSpec.expectedType.isNumeric() && (types == null || types.stream().anyMatch(t -> !t.isNumeric()))) {
                    return NoIndexesColumnIndexSupplier.getInstance();
                }
            }
            return nestedColumnPathIndexSupplier;
        }
        if (this.fieldSpec.parts.isEmpty()) {
            ColumnIndexSupplier baseIndexSupplier = holder.getIndexSupplier();
            if (this.fieldSpec.expectedType != null) {
                if (theColumn instanceof NumericColumn) {
                    return baseIndexSupplier;
                }
                if (theColumn instanceof NestedCommonFormatColumn) {
                    NestedCommonFormatColumn commonFormat = (NestedCommonFormatColumn)theColumn;
                    if (this.fieldSpec.expectedType.isNumeric() && !commonFormat.getLogicalType().isNumeric()) {
                        return NoIndexesColumnIndexSupplier.getInstance();
                    }
                } else {
                    return this.fieldSpec.expectedType.isNumeric() ? NoIndexesColumnIndexSupplier.getInstance() : baseIndexSupplier;
                }
            }
            return baseIndexSupplier;
        }
        if (this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && theColumn instanceof VariantColumn) {
            return NoIndexesColumnIndexSupplier.getInstance();
        }
        return null;
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        if (this.fieldSpec.processFromRaw) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasMultipleValues(false).setHasNulls(true);
        }
        return ColumnCapabilitiesImpl.createDefault().setType(this.fieldSpec.expectedType != null ? this.fieldSpec.expectedType : ColumnType.STRING).setHasNulls(true);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        if (this.fieldSpec.processFromRaw) {
            if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.isArray() && ColumnType.NESTED_DATA.equals(this.fieldSpec.expectedType.getElementType())) {
                return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofArray(ColumnType.NESTED_DATA)).setHasMultipleValues(false).setHasNulls(true);
            }
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasMultipleValues(false).setHasNulls(true);
        }
        ColumnCapabilities capabilities = inspector.getColumnCapabilities(this.fieldSpec.columnName);
        if (capabilities != null) {
            if (capabilities.is(ValueType.COMPLEX) && capabilities.getComplexTypeName().equals("json") && capabilities.isDictionaryEncoded().isTrue()) {
                boolean useDictionary = this.fieldSpec.parts.isEmpty() || !(this.fieldSpec.parts.get(this.fieldSpec.parts.size() - 1) instanceof NestedPathArrayElement);
                return ColumnCapabilitiesImpl.createDefault().setType(this.fieldSpec.expectedType != null ? this.fieldSpec.expectedType : ColumnType.STRING).setDictionaryEncoded(useDictionary).setDictionaryValuesSorted(useDictionary).setDictionaryValuesUnique(useDictionary).setHasBitmapIndexes(useDictionary).setHasNulls(true);
            }
            if (this.fieldSpec.parts.isEmpty()) {
                ColumnCapabilitiesImpl copy = ColumnCapabilitiesImpl.copyOf(capabilities);
                if (this.fieldSpec.expectedType != null) {
                    copy.setType(this.fieldSpec.expectedType);
                    copy.setHasNulls(copy.hasNulls().or(ColumnCapabilities.Capable.of(this.fieldSpec.expectedType.getType() != capabilities.getType())));
                }
                return copy;
            }
            if (capabilities.isPrimitive()) {
                return null;
            }
        }
        return this.capabilities(columnName);
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.fieldSpec.columnName);
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public VirtualColumn.EquivalenceKey getEquivalanceKey() {
        return this.fieldSpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedFieldVirtualColumn that = (NestedFieldVirtualColumn)o;
        return this.outputName.equals(that.outputName) && this.fieldSpec.equals(that.fieldSpec);
    }

    public int hashCode() {
        return Objects.hash(this.outputName, this.fieldSpec);
    }

    public String toString() {
        return "NestedFieldVirtualColumn{columnName='" + this.fieldSpec.columnName + "', outputName='" + this.outputName + "', typeHint='" + this.fieldSpec.expectedType + "', pathParts='" + this.fieldSpec.parts + "', allowFallback=" + this.fieldSpec.processFromRaw + "}";
    }

    private static VectorObjectSelector makeVectorArrayToScalarObjectSelector(final ReadableVectorOffset offset, final VectorObjectSelector delegate, final ExpressionType elementType, final ExpressionType castTo) {
        return new VectorObjectSelector(){
            final Object[] scalars;
            private int id;
            {
                this.scalars = new Object[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (offset.getId() != this.id) {
                    Object[] result = delegate.getObjectVector();
                    for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                        if (result[i] instanceof Object[]) {
                            Object[] o = (Object[])result[i];
                            if (o == null || o.length != 1) {
                                this.scalars[i] = null;
                                continue;
                            }
                            ExprEval element = ExprEval.ofType(elementType, o[0]);
                            this.scalars[i] = element.castTo(castTo).value();
                            continue;
                        }
                        ExprEval element = ExprEval.bestEffortOf(result[i]);
                        this.scalars[i] = element.castTo(castTo).value();
                    }
                    this.id = offset.getId();
                }
                return this.scalars;
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }
        };
    }

    private static class BestEffortCastingValueSelector
    implements DimensionSelector {
        private final DimensionSelector baseSelector;

        public BestEffortCastingValueSelector(DimensionSelector baseSelector) {
            this.baseSelector = baseSelector;
        }

        @Override
        public IndexedInts getRow() {
            return this.baseSelector.getRow();
        }

        @Override
        public ValueMatcher makeValueMatcher(@Nullable String value) {
            return this.baseSelector.makeValueMatcher(value);
        }

        @Override
        public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
            return this.baseSelector.makeValueMatcher(predicateFactory);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            this.baseSelector.inspectRuntimeShape(inspector);
        }

        @Override
        @Nullable
        public Object getObject() {
            return this.baseSelector.getObject();
        }

        @Override
        public Class<?> classOfObject() {
            return this.baseSelector.classOfObject();
        }

        @Override
        public int getValueCardinality() {
            return this.baseSelector.getValueCardinality();
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            return this.baseSelector.lookupName(id);
        }

        @Override
        @Nullable
        public ByteBuffer lookupNameUtf8(int id) {
            return this.baseSelector.lookupNameUtf8(id);
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return this.baseSelector.supportsLookupNameUtf8();
        }

        @Override
        public float getFloat() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0.0f;
            }
            return Numbers.tryParseFloat(this.lookupName(row.get(0)), 0.0f);
        }

        @Override
        public double getDouble() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0.0;
            }
            return Numbers.tryParseDouble(this.lookupName(row.get(0)), 0.0);
        }

        @Override
        public long getLong() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0L;
            }
            return Numbers.tryParseLong(this.lookupName(row.get(0)), 0L);
        }

        @Override
        public boolean isNull() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return true;
            }
            String s = this.lookupName(row.get(0));
            return s == null || Doubles.tryParse((String)s) == null;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return this.baseSelector.nameLookupPossibleInAdvance();
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return this.baseSelector.idLookup();
        }
    }

    public static class FieldDimensionSelector
    extends BaseSingleValueDimensionSelector {
        private final ColumnValueSelector<?> valueSelector;

        public FieldDimensionSelector(ColumnValueSelector<?> valueSelector) {
            this.valueSelector = valueSelector;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("valueSelector", this.valueSelector);
        }

        @Override
        @Nullable
        protected String getValue() {
            Object val = this.valueSelector.getObject();
            if (val == null || val instanceof String) {
                return (String)val;
            }
            return String.valueOf(val);
        }
    }

    public static class RawFieldVectorObjectSelector
    implements VectorObjectSelector {
        private final VectorObjectSelector baseSelector;
        private final List<NestedPathPart> parts;
        private final Object[] vector;

        public RawFieldVectorObjectSelector(VectorObjectSelector baseSelector, List<NestedPathPart> parts) {
            this.baseSelector = baseSelector;
            this.parts = parts;
            this.vector = new Object[baseSelector.getMaxVectorSize()];
        }

        @Override
        public Object[] getObjectVector() {
            Object[] baseVector = this.baseSelector.getObjectVector();
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                this.vector[i] = this.compute(baseVector[i]);
            }
            return this.vector;
        }

        @Override
        public int getMaxVectorSize() {
            return this.baseSelector.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.baseSelector.getCurrentVectorSize();
        }

        private Object compute(Object input) {
            StructuredData data = StructuredData.wrap(input);
            return StructuredData.wrap(NestedPathFinder.find(data == null ? null : data.getValue(), this.parts));
        }
    }

    public static class RawFieldColumnSelector
    implements ColumnValueSelector<Object> {
        protected final ColumnValueSelector baseSelector;
        protected final List<NestedPathPart> parts;

        public RawFieldColumnSelector(ColumnValueSelector baseSelector, List<NestedPathPart> parts) {
            this.baseSelector = baseSelector;
            this.parts = parts;
        }

        @Override
        public double getDouble() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null) {
                return Numbers.tryParseDouble(data.getValue(), 0.0);
            }
            return 0.0;
        }

        @Override
        public float getFloat() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null) {
                return Numbers.tryParseFloat(data.getValue(), 0.0f);
            }
            return 0.0f;
        }

        @Override
        public long getLong() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null) {
                return Numbers.tryParseLong(data.getValue(), 0L);
            }
            return 0L;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseSelector", this.baseSelector);
            inspector.visit("parts", this.parts);
        }

        @Override
        public boolean isNull() {
            StructuredData data = (StructuredData)this.getObject();
            if (data == null) {
                return true;
            }
            Object o = data.getValue();
            return !(o instanceof Number) && (!(o instanceof String) || Doubles.tryParse((String)((String)o)) == null);
        }

        @Override
        @Nullable
        public Object getObject() {
            StructuredData data = StructuredData.wrap(this.baseSelector.getObject());
            return StructuredData.wrap(NestedPathFinder.find(data == null ? null : data.getValue(), this.parts));
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }
    }

    public static class RawFieldLiteralColumnValueSelector
    extends RawFieldColumnSelector {
        public RawFieldLiteralColumnValueSelector(ColumnValueSelector baseSelector, List<NestedPathPart> parts) {
            super(baseSelector, parts);
        }

        @Override
        public double getDouble() {
            Object o = this.getObject();
            return Numbers.tryParseDouble(o, 0.0);
        }

        @Override
        public float getFloat() {
            Object o = this.getObject();
            return Numbers.tryParseFloat(o, 0.0f);
        }

        @Override
        public long getLong() {
            Object o = this.getObject();
            return Numbers.tryParseLong(o, 0L);
        }

        @Override
        public boolean isNull() {
            Object o = this.getObject();
            if (o instanceof Number) {
                return false;
            }
            if (o instanceof String) {
                return GuavaUtils.tryParseLong((String)o) == null && Doubles.tryParse((String)((String)o)) == null;
            }
            return true;
        }

        @Override
        @Nullable
        public Object getObject() {
            StructuredData data = StructuredData.wrap(this.baseSelector.getObject());
            if (data == null) {
                return null;
            }
            Object valAtPath = NestedPathFinder.find(data.getValue(), this.parts);
            ExprEval eval = ExprEval.bestEffortOf(valAtPath);
            if (eval.type().isPrimitive() || eval.type().isPrimitiveArray()) {
                return eval.valueOrDefault();
            }
            return null;
        }
    }

    private static class NestedFieldSpec
    implements VirtualColumn.EquivalenceKey {
        private final String columnName;
        @Nullable
        private final ColumnType expectedType;
        private final List<NestedPathPart> parts;
        private final boolean processFromRaw;

        private NestedFieldSpec(String columnName, @Nullable ColumnType expectedType, List<NestedPathPart> parts, boolean processFromRaw) {
            this.columnName = columnName;
            this.expectedType = expectedType;
            this.parts = parts;
            this.processFromRaw = processFromRaw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedFieldSpec that = (NestedFieldSpec)o;
            return this.processFromRaw == that.processFromRaw && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.expectedType, that.expectedType) && Objects.equals(this.parts, that.parts);
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.expectedType, this.parts, this.processFromRaw);
        }
    }
}

