/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final File storageDirectory;

    @Inject
    public LocalDataSegmentKiller(LocalDataSegmentPusherConfig config) {
        this.storageDirectory = config.getStorageDirectory();
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        File path = this.getPath(segment);
        log.info("Deleting segment[%s] from directory[%s].", new Object[]{segment.getId(), path});
        try {
            if (path.getName().endsWith(".zip") && path.isFile() || path.getName().equals("index") && path.isDirectory()) {
                File parentDir = path.getParentFile();
                FileUtils.deleteDirectory((File)parentDir);
                int maxDepth = 4;
                for (parentDir = parentDir.getParentFile(); parentDir != null && --maxDepth >= 0 && parentDir.listFiles().length <= 0 && parentDir.delete() && !segment.getDataSource().equals(parentDir.getName()); parentDir = parentDir.getParentFile()) {
                }
            } else if (path.exists()) {
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{path});
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
        }
    }

    public void killAll() throws IOException {
        log.info("Deleting all segments from directory[%s].", new Object[]{this.storageDirectory.getAbsolutePath()});
        FileUtils.deleteDirectory((File)this.storageDirectory);
    }

    private File getPath(DataSegment segment) {
        return new File(MapUtils.getString((Map)segment.getLoadSpec(), (String)PATH_KEY));
    }
}

