/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerHelper;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.SinkQueryRunners;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.sink.Sink;
import org.apache.druid.segment.realtime.sink.SinkSegmentReference;
import org.apache.druid.server.ResourceIdPopulatingQueryRunner;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.IntegerPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class SinkQuerySegmentWalker
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(SinkQuerySegmentWalker.class);
    private static final String CONTEXT_SKIP_INCREMENTAL_SEGMENT = "skipIncrementalSegment";
    private static final Set<String> SEGMENT_QUERY_METRIC = ImmutableSet.of((Object)"query/segment/time");
    private static final Set<String> SEGMENT_CACHE_AND_WAIT_METRICS = ImmutableSet.of((Object)"query/wait/time", (Object)"query/segmentAndCache/time");
    private static final Map<String, ObjLongConsumer<? super QueryMetrics<?>>> METRICS_TO_REPORT = ImmutableMap.of((Object)"query/segment/time", QueryMetrics::reportSegmentTime, (Object)"query/segmentAndCache/time", QueryMetrics::reportSegmentAndCacheTime, (Object)"query/wait/time", QueryMetrics::reportWaitTime);
    private final String dataSource;
    private final VersionedIntervalTimeline<String, SinkHolder> upgradedSegmentsTimeline;
    private final ObjectMapper objectMapper;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final QueryProcessingPool queryProcessingPool;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;

    public SinkQuerySegmentWalker(String dataSource, VersionedIntervalTimeline<String, SinkHolder> upgradedSegmentsTimeline, ObjectMapper objectMapper, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, QueryProcessingPool queryProcessingPool, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.upgradedSegmentsTimeline = upgradedSegmentsTimeline;
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.emitter = (ServiceEmitter)Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
        this.conglomerate = (QueryRunnerFactoryConglomerate)Preconditions.checkNotNull((Object)conglomerate, (Object)"conglomerate");
        this.queryProcessingPool = (QueryProcessingPool)Preconditions.checkNotNull((Object)queryProcessingPool, (Object)"queryProcessingPool");
        this.cache = (Cache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.cacheConfig = (CacheConfig)Preconditions.checkNotNull((Object)cacheConfig, (Object)"cacheConfig");
        this.cachePopulatorStats = (CachePopulatorStats)Preconditions.checkNotNull((Object)cachePopulatorStats, (Object)"cachePopulatorStats");
        if (!cache.isLocal()) {
            log.warn("Configured cache[%s] is not local, caching will not be enabled.", new Object[]{cache.getClass().getName()});
        }
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        FunctionalIterable specs = FunctionalIterable.create(intervals).transformCat(arg_0 -> this.upgradedSegmentsTimeline.lookup(arg_0)).transformCat(holder -> FunctionalIterable.create((Iterable)holder.getObject()).transform(chunk -> new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber())));
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)specs);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        DataSource dataSourceFromQuery = query.getDataSource();
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        if (!analysis.getBaseTableDataSource().filter(ds -> this.dataSource.equals(ds.getName())).isPresent()) {
            throw new ISE("Cannot handle datasource: %s", new Object[]{dataSourceFromQuery});
        }
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        QueryToolChest toolChest = factory.getToolchest();
        boolean skipIncrementalSegment = query.context().getBoolean(CONTEXT_SKIP_INCREMENTAL_SEGMENT, false);
        AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{dataSourceFromQuery});
        }
        Function segmentMapFn = dataSourceFromQuery.createSegmentMapFunction(query, cpuTimeAccumulator);
        Optional<byte[]> cacheKeyPrefix = Optional.ofNullable(query.getDataSource().getCacheKey());
        ArrayList<SinkSegmentReference> allSegmentReferences = new ArrayList<SinkSegmentReference>();
        HashMap<SegmentDescriptor, SegmentId> segmentIdMap = new HashMap<SegmentDescriptor, SegmentId>();
        LinkedHashMap<SegmentDescriptor, List<Object>> allRunners = new LinkedHashMap<SegmentDescriptor, List<Object>>();
        ConcurrentHashMap<String, SinkMetricsEmittingQueryRunner.SegmentMetrics> segmentMetricsAccumulator = new ConcurrentHashMap<String, SinkMetricsEmittingQueryRunner.SegmentMetrics>();
        try {
            for (SegmentDescriptor descriptor : specs) {
                PartitionChunk chunk = this.upgradedSegmentsTimeline.findChunk(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getPartitionNumber());
                if (chunk == null) {
                    allRunners.put(descriptor, Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(descriptor)));
                    continue;
                }
                Sink theSink = ((SinkHolder)chunk.getObject()).sink;
                SegmentId sinkSegmentId = theSink.getSegment().getId();
                segmentIdMap.put(descriptor, sinkSegmentId);
                List<SinkSegmentReference> sinkSegmentReferences = theSink.acquireSegmentReferences(segmentMapFn, skipIncrementalSegment);
                if (sinkSegmentReferences == null) {
                    allRunners.put(descriptor, Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(descriptor)));
                    continue;
                }
                if (sinkSegmentReferences.isEmpty()) {
                    allRunners.put(descriptor, Collections.singletonList(new NoopQueryRunner()));
                    continue;
                }
                allSegmentReferences.addAll(sinkSegmentReferences);
                allRunners.put(descriptor, sinkSegmentReferences.stream().map(segmentReference -> {
                    CachingQueryRunner runner = new CachingQueryRunner(this.emitter, factory.getToolchest(), factory.createRunner((Segment)segmentReference.getSegment()), segmentMetricsAccumulator, SEGMENT_QUERY_METRIC, sinkSegmentId.toString());
                    if (segmentReference.isImmutable() && this.cache.isLocal()) {
                        SegmentReference segment = segmentReference.getSegment();
                        TimeBoundaryInspector timeBoundaryInspector = (TimeBoundaryInspector)segment.as(TimeBoundaryInspector.class);
                        Interval cacheKeyInterval = timeBoundaryInspector != null ? timeBoundaryInspector.getMinMaxInterval() : segment.getDataInterval();
                        runner = new CachingQueryRunner(SinkQuerySegmentWalker.makeHydrantCacheIdentifier(sinkSegmentId, segmentReference.getHydrantNumber()), cacheKeyPrefix, descriptor, cacheKeyInterval, this.objectMapper, this.cache, toolChest, runner, new ForegroundCachePopulator(this.objectMapper, this.cachePopulatorStats, this.cacheConfig.getMaxEntrySize()), this.cacheConfig);
                    }
                    runner = new SinkMetricsEmittingQueryRunner(this.emitter, factory.getToolchest(), runner, segmentMetricsAccumulator, SEGMENT_CACHE_AND_WAIT_METRICS, sinkSegmentId.toString());
                    runner = CPUTimeMetricQueryRunner.safeBuild(runner, (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false);
                    runner = new SpecificSegmentQueryRunner((QueryRunner)runner, new SpecificSegmentSpec(descriptor));
                    return runner;
                }).collect(Collectors.toList()));
            }
            QueryRunner mergedRunner = query.context().isBySegment() ? factory.mergeRunners(this.queryProcessingPool, (Iterable)allRunners.entrySet().stream().map(entry -> new BySegmentQueryRunner((SegmentId)segmentIdMap.get(entry.getKey()), ((SegmentDescriptor)entry.getKey()).getInterval().getStart(), factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)entry.getValue()))).collect(Collectors.toList())) : factory.mergeRunners(this.queryProcessingPool, (Iterable)new SinkQueryRunners((Iterable)allRunners.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(runner -> Pair.of((Object)((SegmentDescriptor)entry.getKey()).getInterval(), (Object)runner))).collect(Collectors.toList())));
            return new ResourceIdPopulatingQueryRunner(QueryRunnerHelper.makeClosingQueryRunner((QueryRunner)CPUTimeMetricQueryRunner.safeBuild(new SinkMetricsEmittingQueryRunner(this.emitter, toolChest, new FinalizeResultsQueryRunner(toolChest.mergeResults(mergedRunner, true), toolChest), segmentMetricsAccumulator, Collections.emptySet(), null), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true), () -> CloseableUtils.closeAll((Iterable)allSegmentReferences)));
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, () -> CloseableUtils.closeAll((Iterable)allSegmentReferences));
        }
    }

    public void registerUpgradedPendingSegment(SegmentIdWithShardSpec id, Sink sink) {
        SegmentDescriptor upgradedDescriptor = id.asSegmentId().toDescriptor();
        this.upgradedSegmentsTimeline.add(upgradedDescriptor.getInterval(), (Object)upgradedDescriptor.getVersion(), (PartitionChunk)IntegerPartitionChunk.make(null, null, (int)upgradedDescriptor.getPartitionNumber(), (Overshadowable)new SinkHolder(upgradedDescriptor, sink)));
    }

    public void unregisterUpgradedPendingSegment(SegmentIdWithShardSpec id, Sink sink) {
        SegmentDescriptor upgradedDescriptor = id.asSegmentId().toDescriptor();
        this.upgradedSegmentsTimeline.remove(upgradedDescriptor.getInterval(), (Object)upgradedDescriptor.getVersion(), (PartitionChunk)IntegerPartitionChunk.make(null, null, (int)upgradedDescriptor.getPartitionNumber(), (Overshadowable)new SinkHolder(upgradedDescriptor, sink)));
    }

    @VisibleForTesting
    String getDataSource() {
        return this.dataSource;
    }

    public static String makeHydrantCacheIdentifier(FireHydrant hydrant) {
        return SinkQuerySegmentWalker.makeHydrantCacheIdentifier(hydrant.getSegmentId(), hydrant.getCount());
    }

    public static String makeHydrantCacheIdentifier(SegmentId segmentId, int hydrantNumber) {
        return segmentId + "_H" + hydrantNumber;
    }

    private static class SinkHolder
    implements Overshadowable<SinkHolder> {
        private final Sink sink;
        private final SegmentDescriptor segmentDescriptor;

        private SinkHolder(SegmentDescriptor segmentDescriptor, Sink sink) {
            this.segmentDescriptor = segmentDescriptor;
            this.sink = sink;
        }

        public int getStartRootPartitionId() {
            return this.segmentDescriptor.getPartitionNumber();
        }

        public int getEndRootPartitionId() {
            return this.segmentDescriptor.getPartitionNumber() + 1;
        }

        public String getVersion() {
            return this.segmentDescriptor.getVersion();
        }

        public short getMinorVersion() {
            return 0;
        }

        public short getAtomicUpdateGroupSize() {
            return 1;
        }
    }

    private static class SinkMetricsEmittingQueryRunner<T>
    implements QueryRunner<T> {
        private final ServiceEmitter emitter;
        private final QueryToolChest<T, ? extends Query<T>> queryToolChest;
        private final QueryRunner<T> queryRunner;
        private final ConcurrentHashMap<String, SegmentMetrics> segmentMetricsAccumulator;
        private final Set<String> metricsToCompute;
        @Nullable
        private final String segmentId;
        private final long creationTimeNs;

        private SinkMetricsEmittingQueryRunner(ServiceEmitter emitter, QueryToolChest<T, ? extends Query<T>> queryToolChest, QueryRunner<T> queryRunner, ConcurrentHashMap<String, SegmentMetrics> segmentMetricsAccumulator, Set<String> metricsToCompute, @Nullable String segmentId) {
            this.emitter = emitter;
            this.queryToolChest = queryToolChest;
            this.queryRunner = queryRunner;
            this.segmentMetricsAccumulator = segmentMetricsAccumulator;
            this.metricsToCompute = metricsToCompute;
            this.segmentId = segmentId;
            this.creationTimeNs = System.nanoTime();
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            final QueryPlus queryWithMetrics = queryPlus.withQueryMetrics(this.queryToolChest);
            return Sequences.wrap((Sequence)new LazySequence(() -> this.queryRunner.run(queryWithMetrics, responseContext)), (SequenceWrapper)new SequenceWrapper(){
                private long startTimeNs;

                public void before() {
                    this.startTimeNs = System.nanoTime();
                }

                public void after(boolean isDone, Throwable thrown) {
                    if (segmentId != null) {
                        SegmentMetrics metrics = segmentMetricsAccumulator.computeIfAbsent(segmentId, id -> new SegmentMetrics());
                        if (metricsToCompute.contains("query/wait/time")) {
                            metrics.setWaitTime(this.startTimeNs - creationTimeNs);
                        }
                        if (metricsToCompute.contains("query/segment/time")) {
                            metrics.addSegmentTime(System.nanoTime() - this.startTimeNs);
                        }
                        if (metricsToCompute.contains("query/segmentAndCache/time")) {
                            metrics.addSegmentAndCacheTime(System.nanoTime() - this.startTimeNs);
                        }
                    } else {
                        QueryMetrics queryMetrics = queryWithMetrics.getQueryMetrics();
                        for (Map.Entry<String, SegmentMetrics> segmentAndMetrics : segmentMetricsAccumulator.entrySet()) {
                            queryMetrics.segment(segmentAndMetrics.getKey());
                            for (Map.Entry<String, ObjLongConsumer<QueryMetrics<?>>> reportMetric : METRICS_TO_REPORT.entrySet()) {
                                String metricName;
                                switch (metricName = reportMetric.getKey()) {
                                    case "query/segment/time": {
                                        reportMetric.getValue().accept(queryMetrics, segmentAndMetrics.getValue().getSegmentTime());
                                    }
                                    case "query/wait/time": {
                                        reportMetric.getValue().accept(queryMetrics, segmentAndMetrics.getValue().getWaitTime());
                                    }
                                    case "query/segmentAndCache/time": {
                                        reportMetric.getValue().accept(queryMetrics, segmentAndMetrics.getValue().getSegmentAndCacheTime());
                                    }
                                }
                            }
                            try {
                                queryMetrics.emit(emitter);
                            }
                            catch (Exception e) {
                                log.error((Throwable)e, "Failed to emit metrics for segment[%s]", new Object[]{segmentAndMetrics.getKey()});
                            }
                        }
                    }
                }
            });
        }

        private static class SegmentMetrics {
            private final AtomicLong querySegmentTime = new AtomicLong(0L);
            private final AtomicLong queryWaitTime = new AtomicLong(0L);
            private final AtomicLong querySegmentAndCacheTime = new AtomicLong(0L);

            private SegmentMetrics() {
            }

            private void addSegmentTime(long time) {
                this.querySegmentTime.addAndGet(time);
            }

            private void setWaitTime(long time) {
                this.queryWaitTime.set(time);
            }

            private void addSegmentAndCacheTime(long time) {
                this.querySegmentAndCacheTime.addAndGet(time);
            }

            private long getSegmentTime() {
                return this.querySegmentTime.get();
            }

            private long getWaitTime() {
                return this.queryWaitTime.get();
            }

            private long getSegmentAndCacheTime() {
                return this.querySegmentAndCacheTime.get();
            }
        }
    }
}

