/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.policy.Policy;

public class Access {
    public static final String DEFAULT_ERROR_MESSAGE = "Unauthorized";
    public static final String DEFAULT_AUTHORIZED_MESSAGE = "Authorized";
    public static final Access OK = Access.allow();
    public static final Access DENIED = Access.deny("");
    private final boolean allowed;
    private final String message;
    private final Optional<Policy> policy;

    @Deprecated
    public Access(boolean allowed) {
        this(allowed, "", Optional.empty());
    }

    @Deprecated
    public Access(boolean allowed, String message) {
        this(allowed, message, Optional.empty());
    }

    Access(boolean allowed, String message, Optional<Policy> policy) {
        this.allowed = allowed;
        this.message = message;
        this.policy = policy;
    }

    public static Access allow() {
        return new Access(true, "", Optional.empty());
    }

    public static Access deny(@Nullable String message) {
        return new Access(false, StringUtils.nullToEmptyNonDruidDataString((String)message), null);
    }

    public static Access allowWithRestriction(Policy policy) {
        return new Access(true, "", Optional.of(policy));
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public Optional<Policy> getPolicy() {
        return this.policy;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.allowed ? DEFAULT_AUTHORIZED_MESSAGE : DEFAULT_ERROR_MESSAGE);
        if (!Strings.isNullOrEmpty((String)this.message)) {
            stringBuilder.append(", ");
            stringBuilder.append(this.message);
        }
        if (this.allowed && this.policy.isPresent()) {
            stringBuilder.append(", with restriction [");
            stringBuilder.append(this.policy.get());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return StringUtils.format((String)"Allowed:%s, Message:%s, Policy: %s", (Object[])new Object[]{this.allowed, this.message, this.policy});
    }
}

