/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.kernel.ExtraInfoHolder;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.query.QueryContext;

public class WorkOrder {
    private final QueryDefinition queryDefinition;
    private final int stageNumber;
    private final int workerNumber;
    private final List<InputSlice> workerInputs;
    private final ExtraInfoHolder<?> extraInfoHolder;
    @Nullable
    private final List<String> workerIds;
    @Nullable
    private final OutputChannelMode outputChannelMode;
    @Nullable
    private final QueryContext workerContext;

    @JsonCreator
    public WorkOrder(@JsonProperty(value="query") QueryDefinition queryDefinition, @JsonProperty(value="stage") int stageNumber, @JsonProperty(value="worker") int workerNumber, @JsonProperty(value="input") List<InputSlice> workerInputs, @JsonProperty(value="extra") @Nullable ExtraInfoHolder extraInfoHolder, @JsonProperty(value="workers") @Nullable List<String> workerIds, @JsonProperty(value="output") @Nullable OutputChannelMode outputChannelMode, @JsonProperty(value="context") @Nullable Map<String, Object> workerContext) {
        this.queryDefinition = (QueryDefinition)Preconditions.checkNotNull((Object)queryDefinition, (Object)"queryDefinition");
        this.stageNumber = stageNumber;
        this.workerNumber = workerNumber;
        this.workerInputs = (List)Preconditions.checkNotNull(workerInputs, (Object)"workerInputs");
        this.extraInfoHolder = extraInfoHolder;
        this.workerIds = workerIds;
        this.outputChannelMode = outputChannelMode;
        this.workerContext = workerContext != null ? QueryContext.of(workerContext) : null;
    }

    @JsonProperty(value="query")
    public QueryDefinition getQueryDefinition() {
        return this.queryDefinition;
    }

    @JsonProperty(value="stage")
    public int getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty(value="worker")
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @JsonProperty(value="input")
    public List<InputSlice> getInputs() {
        return this.workerInputs;
    }

    @Nullable
    @JsonProperty(value="extra")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    ExtraInfoHolder<?> getExtraInfoHolder() {
        return this.extraInfoHolder;
    }

    @Nullable
    @JsonProperty(value="workers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getWorkerIds() {
        return this.workerIds;
    }

    public boolean hasOutputChannelMode() {
        return this.outputChannelMode != null;
    }

    @Nullable
    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OutputChannelMode getOutputChannelMode() {
        return this.outputChannelMode;
    }

    public boolean hasWorkerContext() {
        return this.workerContext != null;
    }

    @Nullable
    public QueryContext getWorkerContext() {
        return this.workerContext;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getContextForSerialization() {
        return this.workerContext != null ? this.workerContext.asMap() : null;
    }

    @Nullable
    public Object getExtraInfo() {
        return this.extraInfoHolder != null ? this.extraInfoHolder.getExtraInfo() : null;
    }

    public StageDefinition getStageDefinition() {
        return this.queryDefinition.getStageDefinition(this.stageNumber);
    }

    public WorkOrder withOutputChannelMode(OutputChannelMode newOutputChannelMode) {
        if (newOutputChannelMode == this.outputChannelMode) {
            return this;
        }
        return new WorkOrder(this.queryDefinition, this.stageNumber, this.workerNumber, this.workerInputs, this.extraInfoHolder, this.workerIds, newOutputChannelMode, this.workerContext != null ? this.workerContext.asMap() : null);
    }

    public WorkOrder withWorkerContext(QueryContext newContext) {
        if (Objects.equals(newContext, this.workerContext)) {
            return this;
        }
        return new WorkOrder(this.queryDefinition, this.stageNumber, this.workerNumber, this.workerInputs, this.extraInfoHolder, this.workerIds, this.outputChannelMode, newContext.asMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkOrder workOrder = (WorkOrder)o;
        return this.stageNumber == workOrder.stageNumber && this.workerNumber == workOrder.workerNumber && Objects.equals(this.queryDefinition, workOrder.queryDefinition) && Objects.equals(this.workerInputs, workOrder.workerInputs) && Objects.equals(this.extraInfoHolder, workOrder.extraInfoHolder) && Objects.equals(this.workerIds, workOrder.workerIds) && Objects.equals((Object)this.outputChannelMode, (Object)workOrder.outputChannelMode) && Objects.equals(this.workerContext, workOrder.workerContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryDefinition, this.stageNumber, this.workerNumber, this.workerInputs, this.extraInfoHolder, this.workerIds, this.outputChannelMode, this.workerContext});
    }

    public String toString() {
        return "WorkOrder{queryDefinition=" + this.queryDefinition + ", stageNumber=" + this.stageNumber + ", workerNumber=" + this.workerNumber + ", workerInputs=" + this.workerInputs + ", extraInfoHolder=" + this.extraInfoHolder + ", workerIds=" + this.workerIds + ", outputChannelMode=" + this.outputChannelMode + ", context=" + this.workerContext + "}";
    }
}

