/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.indexing.destination.MSQDestination;

public class ControllerQueryKernelConfig {
    private final int maxRetainedPartitionSketchBytes;
    private final int maxConcurrentStages;
    private final boolean pipeline;
    private final boolean durableStorage;
    private final boolean faultTolerance;
    private final MSQDestination destination;
    @Nullable
    private final String controllerHost;
    @Nullable
    private final List<String> workerIds;
    private final Map<String, Object> workerContextMap;

    ControllerQueryKernelConfig(int maxRetainedPartitionSketchBytes, int maxConcurrentStages, boolean pipeline, boolean durableStorage, boolean faultTolerance, MSQDestination destination, @Nullable String controllerHost, @Nullable List<String> workerIds, Map<String, Object> workerContextMap) {
        if (maxRetainedPartitionSketchBytes <= 0) {
            throw new IAE("maxRetainedPartitionSketchBytes must be positive", new Object[0]);
        }
        if (pipeline && maxConcurrentStages < 2) {
            throw new IAE("maxConcurrentStagesPerWorker must be >= 2 when pipelining", new Object[0]);
        }
        if (maxConcurrentStages <= 0) {
            throw new IAE("maxConcurrentStagesPerWorker must be positive", new Object[0]);
        }
        if (pipeline && faultTolerance) {
            throw new IAE("Cannot pipeline with fault tolerance", new Object[0]);
        }
        if (pipeline && durableStorage) {
            throw new IAE("Cannot pipeline with durable storage", new Object[0]);
        }
        if (faultTolerance && !durableStorage) {
            throw new IAE("Cannot have fault tolerance without durable storage", new Object[0]);
        }
        this.maxRetainedPartitionSketchBytes = maxRetainedPartitionSketchBytes;
        this.maxConcurrentStages = maxConcurrentStages;
        this.pipeline = pipeline;
        this.durableStorage = durableStorage;
        this.faultTolerance = faultTolerance;
        this.destination = destination;
        this.controllerHost = controllerHost;
        this.workerIds = workerIds;
        this.workerContextMap = workerContextMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxRetainedPartitionSketchBytes() {
        return this.maxRetainedPartitionSketchBytes;
    }

    public int getMaxConcurrentStages() {
        return this.maxConcurrentStages;
    }

    public boolean isPipeline() {
        return this.pipeline;
    }

    public boolean isDurableStorage() {
        return this.durableStorage;
    }

    public boolean isFaultTolerant() {
        return this.faultTolerance;
    }

    public MSQDestination getDestination() {
        return this.destination;
    }

    @Nullable
    public List<String> getWorkerIds() {
        return this.workerIds;
    }

    public Map<String, Object> getWorkerContextMap() {
        return this.workerContextMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControllerQueryKernelConfig that = (ControllerQueryKernelConfig)o;
        return this.maxRetainedPartitionSketchBytes == that.maxRetainedPartitionSketchBytes && this.maxConcurrentStages == that.maxConcurrentStages && this.pipeline == that.pipeline && this.durableStorage == that.durableStorage && this.faultTolerance == that.faultTolerance && Objects.equals(this.destination, that.destination) && Objects.equals(this.controllerHost, that.controllerHost) && Objects.equals(this.workerIds, that.workerIds) && Objects.equals(this.workerContextMap, that.workerContextMap);
    }

    public int hashCode() {
        return Objects.hash(this.maxRetainedPartitionSketchBytes, this.maxConcurrentStages, this.pipeline, this.durableStorage, this.faultTolerance, this.destination, this.controllerHost, this.workerIds, this.workerContextMap);
    }

    public String toString() {
        return "ControllerQueryKernelConfig{maxRetainedPartitionSketchBytes=" + this.maxRetainedPartitionSketchBytes + ", maxConcurrentStages=" + this.maxConcurrentStages + ", pipeline=" + this.pipeline + ", durableStorage=" + this.durableStorage + ", faultTolerance=" + this.faultTolerance + ", destination=" + this.destination + ", controllerHost='" + this.controllerHost + "', workerIds=" + this.workerIds + ", workerContextMap=" + this.workerContextMap + "}";
    }

    public static class Builder {
        private int maxRetainedPartitionSketchBytes = -1;
        private int maxConcurrentStages = 1;
        private boolean pipeline;
        private boolean durableStorage;
        private boolean faultTolerant;
        private MSQDestination destination;
        private String controllerHost;
        private List<String> workerIds;
        private Map<String, Object> workerContextMap = Collections.emptyMap();

        private Builder() {
        }

        public Builder maxRetainedPartitionSketchBytes(int maxRetainedPartitionSketchBytes) {
            this.maxRetainedPartitionSketchBytes = maxRetainedPartitionSketchBytes;
            return this;
        }

        public Builder maxConcurrentStages(int maxConcurrentStages) {
            this.maxConcurrentStages = maxConcurrentStages;
            return this;
        }

        public Builder pipeline(boolean pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder durableStorage(boolean durableStorage) {
            this.durableStorage = durableStorage;
            return this;
        }

        public Builder faultTolerance(boolean faultTolerant) {
            this.faultTolerant = faultTolerant;
            return this;
        }

        public Builder destination(MSQDestination destination) {
            this.destination = destination;
            return this;
        }

        public Builder controllerHost(String controllerHost) {
            this.controllerHost = controllerHost;
            return this;
        }

        public Builder workerIds(List<String> workerIds) {
            this.workerIds = workerIds;
            return this;
        }

        public Builder workerContextMap(Map<String, Object> workerContextMap) {
            this.workerContextMap = workerContextMap;
            return this;
        }

        public ControllerQueryKernelConfig build() {
            return new ControllerQueryKernelConfig(this.maxRetainedPartitionSketchBytes, this.maxConcurrentStages, this.pipeline, this.durableStorage, this.faultTolerant, this.destination, this.controllerHost, this.workerIds, this.workerContextMap);
        }
    }
}

