/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2LimitResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:   - How are requests for this priority level limited?   - What should be done with requests that exceed the limit?")
public class V1beta2LimitedPriorityLevelConfiguration {
    public static final String SERIALIZED_NAME_ASSURED_CONCURRENCY_SHARES = "assuredConcurrencyShares";
    @SerializedName(value="assuredConcurrencyShares")
    private Integer assuredConcurrencyShares;
    public static final String SERIALIZED_NAME_BORROWING_LIMIT_PERCENT = "borrowingLimitPercent";
    @SerializedName(value="borrowingLimitPercent")
    private Integer borrowingLimitPercent;
    public static final String SERIALIZED_NAME_LENDABLE_PERCENT = "lendablePercent";
    @SerializedName(value="lendablePercent")
    private Integer lendablePercent;
    public static final String SERIALIZED_NAME_LIMIT_RESPONSE = "limitResponse";
    @SerializedName(value="limitResponse")
    private V1beta2LimitResponse limitResponse;

    public V1beta2LimitedPriorityLevelConfiguration assuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`assuredConcurrencyShares` (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.  ACS must be a positive number. The server's concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:              ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )  bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.")
    public Integer getAssuredConcurrencyShares() {
        return this.assuredConcurrencyShares;
    }

    public void setAssuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
    }

    public V1beta2LimitedPriorityLevelConfiguration borrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.  BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )  The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.")
    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    public void setBorrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
    }

    public V1beta2LimitedPriorityLevelConfiguration lendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.  LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )")
    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    public void setLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
    }

    public V1beta2LimitedPriorityLevelConfiguration limitResponse(V1beta2LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta2LimitResponse getLimitResponse() {
        return this.limitResponse;
    }

    public void setLimitResponse(V1beta2LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2LimitedPriorityLevelConfiguration v1beta2LimitedPriorityLevelConfiguration = (V1beta2LimitedPriorityLevelConfiguration)o;
        return Objects.equals(this.assuredConcurrencyShares, v1beta2LimitedPriorityLevelConfiguration.assuredConcurrencyShares) && Objects.equals(this.borrowingLimitPercent, v1beta2LimitedPriorityLevelConfiguration.borrowingLimitPercent) && Objects.equals(this.lendablePercent, v1beta2LimitedPriorityLevelConfiguration.lendablePercent) && Objects.equals(this.limitResponse, v1beta2LimitedPriorityLevelConfiguration.limitResponse);
    }

    public int hashCode() {
        return Objects.hash(this.assuredConcurrencyShares, this.borrowingLimitPercent, this.lendablePercent, this.limitResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2LimitedPriorityLevelConfiguration {\n");
        sb.append("    assuredConcurrencyShares: ").append(this.toIndentedString(this.assuredConcurrencyShares)).append("\n");
        sb.append("    borrowingLimitPercent: ").append(this.toIndentedString(this.borrowingLimitPercent)).append("\n");
        sb.append("    lendablePercent: ").append(this.toIndentedString(this.lendablePercent)).append("\n");
        sb.append("    limitResponse: ").append(this.toIndentedString(this.limitResponse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

