/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.tools.FileObject;
import org.apache.druid.common.aws.AWSClientUtil;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.URIDataPuller;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.utils.CompressionUtils;

public class S3DataSegmentPuller
implements URIDataPuller {
    private static final Logger log = new Logger(S3DataSegmentPuller.class);
    static final String BUCKET = "bucket";
    protected static final String KEY = "key";
    protected final ServerSideEncryptingAmazonS3 s3Client;

    @Inject
    public S3DataSegmentPuller(ServerSideEncryptingAmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    FileUtils.FileCopyResult getSegmentFiles(CloudObjectLocation s3Coords, File outDir) throws SegmentLoadingException {
        log.info("Pulling index at path[%s] to outDir[%s]", new Object[]{s3Coords, outDir});
        if (!this.isObjectInBucket(s3Coords)) {
            throw new SegmentLoadingException("IndexFile[%s] does not exist.", new Object[]{s3Coords});
        }
        try {
            FileUtils.mkdirp((File)outDir);
            final URI uri = s3Coords.toUri("s3");
            ByteSource byteSource = new ByteSource(){

                public InputStream openStream() throws IOException {
                    try {
                        return S3DataSegmentPuller.this.buildFileObject(uri).openInputStream();
                    }
                    catch (AmazonServiceException e) {
                        if (e.getCause() != null && S3Utils.S3RETRY.apply((Object)e)) {
                            throw new IOException("Recoverable exception", e);
                        }
                        throw new RuntimeException(e);
                    }
                }
            };
            if (CompressionUtils.isZip((String)s3Coords.getPath())) {
                FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)byteSource, (File)outDir, S3Utils.S3RETRY, (boolean)false);
                log.info("Loaded %d bytes from [%s] to [%s]", new Object[]{result.size(), s3Coords.toString(), outDir.getAbsolutePath()});
                return result;
            }
            if (CompressionUtils.isGz((String)s3Coords.getPath())) {
                String fname = Files.getNameWithoutExtension((String)uri.getPath());
                File outFile = new File(outDir, fname);
                FileUtils.FileCopyResult result = CompressionUtils.gunzip((ByteSource)byteSource, (File)outFile, S3Utils.S3RETRY);
                log.info("Loaded %d bytes from [%s] to [%s]", new Object[]{result.size(), s3Coords.toString(), outFile.getAbsolutePath()});
                return result;
            }
            throw new IAE("Do not know how to load file type at [%s]", new Object[]{uri.toString()});
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory((File)outDir);
            }
            catch (IOException ioe) {
                log.warn((Throwable)ioe, "Failed to remove output directory [%s] for segment pulled from [%s]", new Object[]{outDir.getAbsolutePath(), s3Coords.toString()});
            }
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public InputStream getInputStream(URI uri) throws IOException {
        try {
            return this.buildFileObject(uri).openInputStream();
        }
        catch (AmazonServiceException e) {
            throw new IOE((Throwable)e, "Could not load URI [%s]", new Object[]{uri});
        }
    }

    public FileObject buildFileObject(final URI uri) throws AmazonServiceException {
        final CloudObjectLocation coords = new CloudObjectLocation(S3Utils.checkURI(uri));
        final String path = uri.getPath();
        return new FileObject(){
            S3Object s3Object = null;
            ObjectMetadata objectMetadata = null;

            @Override
            public URI toUri() {
                return uri;
            }

            @Override
            public String getName() {
                String ext = Files.getFileExtension((String)path);
                return Files.getNameWithoutExtension((String)path) + (String)(Strings.isNullOrEmpty((String)ext) ? "" : "." + ext);
            }

            @Override
            public InputStream openInputStream() throws IOException {
                try {
                    if (this.s3Object == null) {
                        this.s3Object = S3DataSegmentPuller.this.s3Client.getObject(coords.getBucket(), coords.getPath());
                    }
                    S3ObjectInputStream in = this.s3Object.getObjectContent();
                    final Closer closer = Closer.create();
                    closer.register((Closeable)in);
                    closer.register((Closeable)this.s3Object);
                    return new FilterInputStream((InputStream)in){

                        @Override
                        public void close() throws IOException {
                            closer.close();
                        }
                    };
                }
                catch (AmazonServiceException e) {
                    throw new IOE((Throwable)e, "Could not load S3 URI [%s]", new Object[]{uri});
                }
            }

            @Override
            public OutputStream openOutputStream() {
                throw new UOE("Cannot stream S3 output", new Object[0]);
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) {
                throw new UOE("Cannot open reader", new Object[0]);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                throw new UOE("Cannot open character sequence", new Object[0]);
            }

            @Override
            public Writer openWriter() {
                throw new UOE("Cannot open writer", new Object[0]);
            }

            @Override
            public long getLastModified() {
                if (this.s3Object != null) {
                    return this.s3Object.getObjectMetadata().getLastModified().getTime();
                }
                if (this.objectMetadata == null) {
                    this.objectMetadata = S3Utils.getSingleObjectMetadata(S3DataSegmentPuller.this.s3Client, coords.getBucket(), coords.getPath());
                }
                return this.objectMetadata.getLastModified().getTime();
            }

            @Override
            public boolean delete() {
                throw new UOE("Cannot delete S3 items anonymously. jetS3t doesn't support authenticated deletes easily.", new Object[0]);
            }
        };
    }

    public Predicate<Throwable> shouldRetryPredicate() {
        return S3Utils.S3RETRY;
    }

    public String getVersion(URI uri) throws IOException {
        try {
            CloudObjectLocation coords = new CloudObjectLocation(S3Utils.checkURI(uri));
            ObjectMetadata objectMetadata = S3Utils.getSingleObjectMetadata(this.s3Client, coords.getBucket(), coords.getPath());
            return StringUtils.format((String)"%d", (Object[])new Object[]{objectMetadata.getLastModified().getTime()});
        }
        catch (AmazonClientException e) {
            if (AWSClientUtil.isClientExceptionRecoverable((AmazonClientException)e)) {
                throw new IOE((Throwable)e, "Could not fetch last modified timestamp from URI [%s]", new Object[]{uri});
            }
            throw new RE((Throwable)e, "Error fetching last modified timestamp from URI [%s]", new Object[]{uri});
        }
    }

    private boolean isObjectInBucket(CloudObjectLocation coords) throws SegmentLoadingException {
        try {
            return (Boolean)S3Utils.retryS3Operation(() -> S3Utils.isObjectInBucketIgnoringPermission(this.s3Client, coords.getBucket(), coords.getPath()));
        }
        catch (AmazonS3Exception | IOException e) {
            throw new SegmentLoadingException(e, "S3 fail! Key[%s]", new Object[]{coords});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

