/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.Configs;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class MSQResultsReport {
    private final List<ColumnAndType> signature;
    @Nullable
    private final List<SqlTypeName> sqlTypeNames;
    private final List<Object[]> results;
    private final boolean resultsTruncated;

    @JsonCreator
    public MSQResultsReport(@JsonProperty(value="signature") List<ColumnAndType> signature, @JsonProperty(value="sqlTypeNames") @Nullable List<SqlTypeName> sqlTypeNames, @JsonProperty(value="results") List<Object[]> results, @JsonProperty(value="resultsTruncated") Boolean resultsTruncated) {
        this.signature = (List)Preconditions.checkNotNull(signature, (Object)"signature");
        this.sqlTypeNames = sqlTypeNames;
        this.results = (List)Preconditions.checkNotNull(results, (Object)"results");
        this.resultsTruncated = Configs.valueOrDefault((Boolean)resultsTruncated, (boolean)false);
    }

    @JsonProperty(value="signature")
    public List<ColumnAndType> getSignature() {
        return this.signature;
    }

    @Nullable
    @JsonProperty(value="sqlTypeNames")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SqlTypeName> getSqlTypeNames() {
        return this.sqlTypeNames;
    }

    @JsonProperty(value="results")
    public List<Object[]> getResults() {
        return this.results;
    }

    @JsonProperty(value="resultsTruncated")
    public boolean isResultsTruncated() {
        return this.resultsTruncated;
    }

    public static class ColumnAndType {
        private final String name;
        private final ColumnType type;

        @JsonCreator
        public ColumnAndType(@JsonProperty(value="name") String name, @JsonProperty(value="type") ColumnType type) {
            this.name = name;
            this.type = type;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ColumnType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnAndType that = (ColumnAndType)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return this.name + ":" + String.valueOf(this.type);
        }

        public static RowSignature toRowSignature(List<ColumnAndType> columnAndTypes) {
            RowSignature.Builder builder = RowSignature.builder();
            for (ColumnAndType columnAndType : columnAndTypes) {
                builder.add(columnAndType.getName(), columnAndType.getType());
            }
            RowSignature rowSignature = builder.build();
            if (rowSignature.size() != columnAndTypes.size()) {
                throw new IllegalArgumentException("Duplicate column names are not allowed in RowSignature");
            }
            return rowSignature;
        }
    }
}

