/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;

public abstract class DescriptorBasedProtobufBytesDecoder
implements ProtobufBytesDecoder {
    private Descriptors.Descriptor descriptor;
    private final String protoMessageType;

    public DescriptorBasedProtobufBytesDecoder(String protoMessageType) {
        this.protoMessageType = protoMessageType;
    }

    @JsonProperty
    public String getProtoMessageType() {
        return this.protoMessageType;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    void initDescriptor() {
        if (this.descriptor == null) {
            DynamicSchema dynamicSchema = this.generateDynamicSchema();
            this.descriptor = this.generateDescriptor(dynamicSchema);
        }
    }

    protected abstract DynamicSchema generateDynamicSchema();

    @Override
    public DynamicMessage parse(ByteBuffer bytes) {
        try {
            DynamicMessage message = DynamicMessage.parseFrom(this.descriptor, ByteString.copyFrom(bytes));
            return message;
        }
        catch (Exception e) {
            throw new ParseException(null, (Throwable)e, "Fail to decode protobuf message!", new Object[0]);
        }
    }

    private Descriptors.Descriptor generateDescriptor(DynamicSchema dynamicSchema) {
        Set<String> messageTypes = dynamicSchema.getMessageTypes();
        if (messageTypes.size() == 0) {
            throw new ParseException(null, "No message types found in the descriptor.", new Object[0]);
        }
        String messageType = this.protoMessageType == null ? (String)messageTypes.toArray()[0] : this.protoMessageType;
        Descriptors.Descriptor desc = dynamicSchema.getMessageDescriptor(messageType);
        if (desc == null) {
            throw new ParseException(null, StringUtils.format((String)"Protobuf message type %s not found in the specified descriptor.  Available messages types are %s", (Object[])new Object[]{this.protoMessageType, messageTypes}), new Object[0]);
        }
        return desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorBasedProtobufBytesDecoder that = (DescriptorBasedProtobufBytesDecoder)o;
        return Objects.equals(this.getProtoMessageType(), that.getProtoMessageType());
    }

    public int hashCode() {
        return Objects.hash(this.getProtoMessageType());
    }
}

