/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.compact.CompactionSupervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class CompactionSupervisorSpec
implements SupervisorSpec {
    public static final String TYPE = "autocompact";
    public static final String ID_PREFIX = "autocompact__";
    private final boolean suspended;
    private final DataSourceCompactionConfig spec;
    private final CompactionScheduler scheduler;
    private final CompactionConfigValidationResult validationResult;

    public static String getSupervisorIdForDatasource(String dataSource) {
        return ID_PREFIX + dataSource;
    }

    @JsonCreator
    public CompactionSupervisorSpec(@JsonProperty(value="spec") DataSourceCompactionConfig spec, @JsonProperty(value="suspended") @Nullable Boolean suspended, @JacksonInject CompactionScheduler scheduler) {
        this.spec = spec;
        this.suspended = Configs.valueOrDefault((Boolean)suspended, (boolean)false);
        this.scheduler = scheduler;
        this.validationResult = scheduler.validateCompactionConfig(spec);
    }

    @JsonProperty
    public DataSourceCompactionConfig getSpec() {
        return this.spec;
    }

    @JsonProperty
    public boolean isSuspended() {
        return this.suspended;
    }

    public String getId() {
        return CompactionSupervisorSpec.getSupervisorIdForDatasource(this.spec.getDataSource());
    }

    public CompactionConfigValidationResult getValidationResult() {
        return this.validationResult;
    }

    public CompactionSupervisor createSupervisor() {
        return new CompactionSupervisor(this, this.scheduler);
    }

    public List<String> getDataSources() {
        return Collections.singletonList(this.spec.getDataSource());
    }

    public CompactionSupervisorSpec createSuspendedSpec() {
        return new CompactionSupervisorSpec(this.spec, true, this.scheduler);
    }

    public CompactionSupervisorSpec createRunningSpec() {
        return new CompactionSupervisorSpec(this.spec, false, this.scheduler);
    }

    public String getType() {
        return TYPE;
    }

    public String getSource() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionSupervisorSpec that = (CompactionSupervisorSpec)o;
        return this.suspended == that.suspended && Objects.equals(this.spec, that.spec);
    }

    public int hashCode() {
        return Objects.hash(this.suspended, this.spec);
    }
}

