/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.TextReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public class RegexReader
extends TextReader.Strings {
    private final String pattern;
    private final Pattern compiledPattern;
    private final Function<String, Object> transformationFunction;
    private List<String> columns;

    RegexReader(InputRowSchema inputRowSchema, InputEntity source, String pattern, Pattern compiledPattern, @Nullable String listDelimiter, @Nullable List<String> columns) {
        super(inputRowSchema, source);
        this.pattern = pattern;
        this.compiledPattern = compiledPattern;
        String finalListDelimeter = listDelimiter == null ? "\u0001" : listDelimiter;
        this.transformationFunction = ParserUtils.getTransformationFunction(finalListDelimeter, Splitter.on((String)finalListDelimeter), false);
        this.columns = columns;
    }

    @Override
    public List<InputRow> parseInputRows(String intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema(), this.parseLine(intermediateRow)));
    }

    @Override
    protected List<Map<String, Object>> toMap(String intermediateRow) {
        return Collections.singletonList(this.parseLine(intermediateRow));
    }

    private Map<String, Object> parseLine(String line) {
        try {
            Matcher matcher = this.compiledPattern.matcher(line);
            if (!matcher.matches()) {
                throw new ParseException(line, "Incorrect Regex: %s . No match found.", this.pattern);
            }
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                values.add(matcher.group(i));
            }
            if (this.columns == null) {
                this.columns = ParserUtils.generateFieldNames(matcher.groupCount());
            }
            return Utils.zipMapPartial(this.columns, Iterables.transform(values, this.transformationFunction));
        }
        catch (Exception e) {
            throw new ParseException(line, (Throwable)e, "Unable to parse row [%s]", line);
        }
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return 0;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return false;
    }

    @Override
    public void processHeaderLine(String line) {
    }
}

