/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatMaxVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public FloatMaxVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putFloat(position, Float.NEGATIVE_INFINITY);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        float max = buf.getFloat(position);
        for (int i = startRow; i < endRow; ++i) {
            max = Math.max(max, vector[i]);
        }
        buf.putFloat(position, max);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] vector = this.selector.getFloatVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putFloat(position, Math.max(buf.getFloat(position), vector[rows != null ? rows[i] : i]));
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return Float.valueOf(buf.getFloat(position));
    }

    @Override
    public void close() {
    }
}

