/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.serde.ComplexMetricExtractor;

public class PreComputedHyperUniquesSerde
extends HyperUniquesSerde {
    public static final String TYPE_NAME = "preComputedHyperUnique";

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue == null) {
                    return HyperLogLogCollector.makeLatestCollector();
                }
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                if (rawValue instanceof byte[]) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap((byte[])rawValue));
                }
                if (rawValue instanceof String) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap(StringUtils.decodeBase64String((String)rawValue)));
                }
                throw new ISE("Object is not of a type[%s] that can be deserialized to HyperLogLog.", rawValue.getClass());
            }
        };
    }
}

