/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.SimpleColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.serde.NullValueIndexSupplier;

public class ColumnBuilder {
    private final ColumnCapabilitiesImpl capabilitiesBuilder = ColumnCapabilitiesImpl.createDefault();
    @Nullable
    private Supplier<? extends BaseColumn> columnSupplier = null;
    @Nullable
    private ColumnIndexSupplier indexSupplier = NoIndexesColumnIndexSupplier.getInstance();
    @Nullable
    private SmooshedFileMapper fileMapper = null;
    @Nullable
    private ColumnFormat columnFormat = null;

    public ColumnCapabilitiesImpl getCapabilitiesBuilder() {
        return this.capabilitiesBuilder;
    }

    public ColumnBuilder setFileMapper(SmooshedFileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return this;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public ColumnBuilder setType(ColumnType type) {
        this.capabilitiesBuilder.setType(type);
        return this;
    }

    public ColumnBuilder setType(ValueType type) {
        this.capabilitiesBuilder.setType(ColumnTypeFactory.ofValueType(type));
        return this;
    }

    public ColumnBuilder setComplexTypeName(String typeName) {
        this.capabilitiesBuilder.setType(ColumnType.ofComplex(typeName));
        return this;
    }

    public ColumnBuilder setHasMultipleValues(boolean hasMultipleValues) {
        this.capabilitiesBuilder.setHasMultipleValues(hasMultipleValues);
        return this;
    }

    public ColumnBuilder setDictionaryEncodedColumnSupplier(Supplier<? extends DictionaryEncodedColumn<?>> columnSupplier) {
        this.checkColumnSupplierNotSet();
        this.columnSupplier = columnSupplier;
        this.capabilitiesBuilder.setDictionaryEncoded(true);
        this.capabilitiesBuilder.setDictionaryValuesSorted(true);
        this.capabilitiesBuilder.setDictionaryValuesUnique(true);
        return this;
    }

    public ColumnBuilder setComplexColumnSupplier(Supplier<? extends ComplexColumn> columnSupplier) {
        this.checkColumnSupplierNotSet();
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setNumericColumnSupplier(Supplier<? extends NumericColumn> columnSupplier) {
        this.checkColumnSupplierNotSet();
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setNestedCommonFormatColumnSupplier(Supplier<? extends NestedCommonFormatColumn> columnSupplier) {
        this.checkColumnSupplierNotSet();
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setIndexSupplier(@Nullable ColumnIndexSupplier indexSupplier, boolean hasBitmapIndex, boolean hasSpatial) {
        this.checkIndexSupplierNotSet();
        this.indexSupplier = indexSupplier;
        this.capabilitiesBuilder.setHasBitmapIndexes(hasBitmapIndex);
        this.capabilitiesBuilder.setHasSpatialIndexes(hasSpatial);
        return this;
    }

    public ColumnBuilder setNullValueIndexSupplier(ImmutableBitmap nullValueIndex) {
        this.checkIndexSupplierNotSet();
        this.indexSupplier = new NullValueIndexSupplier(nullValueIndex);
        return this;
    }

    public ColumnBuilder setHasNulls(boolean nullable) {
        this.capabilitiesBuilder.setHasNulls(nullable);
        return this;
    }

    public ColumnBuilder setHasNulls(ColumnCapabilities.Capable nullable) {
        this.capabilitiesBuilder.setHasNulls(nullable);
        return this;
    }

    public ColumnBuilder setColumnFormat(ColumnFormat columnFormat) {
        this.columnFormat = columnFormat;
        return this;
    }

    public ColumnHolder build() {
        Preconditions.checkState((this.capabilitiesBuilder.getType() != null ? 1 : 0) != 0, (Object)"Type must be set.");
        return new SimpleColumnHolder(this.capabilitiesBuilder, this.columnFormat, this.columnSupplier, this.indexSupplier);
    }

    private void checkColumnSupplierNotSet() {
        if (this.columnSupplier != null) {
            throw new ISE("Column supplier already set!", new Object[0]);
        }
    }

    private void checkIndexSupplierNotSet() {
        if (this.indexSupplier != NoIndexesColumnIndexSupplier.getInstance()) {
            throw new ISE("Index supplier already set!", new Object[0]);
        }
    }
}

