/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.http.SegmentLoadingMode;
import org.apache.druid.utils.JvmUtils;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long markSegmentAsUnusedDelayMillis;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean useRoundRobinSegmentAssignment;
    private final boolean smartSegmentLoading;
    private final Set<String> specificDataSourcesToKillUnusedSegmentsIn;
    private final double killTaskSlotRatio;
    private final int maxKillTaskSlots;
    private final Set<String> decommissioningNodes;
    private final Map<String, String> debugDimensions;
    private final Map<Dimension, String> validDebugDimensions;
    private final Set<String> turboLoadingNodes;
    private final Set<String> dataSourcesToNotKillStalePendingSegmentsIn;
    private final int maxSegmentsInNodeLoadingQueue;
    private final boolean pauseCoordination;
    private final boolean replicateAfterLoadTimeout;

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long markSegmentAsUnusedDelayMillis, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="killDataSourceWhitelist") Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killTaskSlotRatio") @Nullable Double killTaskSlotRatio, @JsonProperty(value="maxKillTaskSlots") @Nullable Integer maxKillTaskSlots, @JsonProperty(value="killPendingSegmentsSkipList") Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") Object decommissioningNodes, @JsonProperty(value="pauseCoordination") boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") boolean replicateAfterLoadTimeout, @JsonProperty(value="useRoundRobinSegmentAssignment") @Nullable Boolean useRoundRobinSegmentAssignment, @JsonProperty(value="smartSegmentLoading") @Nullable Boolean smartSegmentLoading, @JsonProperty(value="debugDimensions") @Nullable Map<String, String> debugDimensions, @JsonProperty(value="turboLoadingNodes") @Nullable Set<String> turboLoadingNodes) {
        this.markSegmentAsUnusedDelayMillis = markSegmentAsUnusedDelayMillis;
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.smartSegmentLoading = Builder.valueOrDefault(smartSegmentLoading, true);
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.specificDataSourcesToKillUnusedSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(specificDataSourcesToKillUnusedSegmentsIn);
        if (null != killTaskSlotRatio && (killTaskSlotRatio < 0.0 || killTaskSlotRatio > 1.0)) {
            throw InvalidInput.exception((String)"killTaskSlotRatio [%.2f] is invalid. It must be >= 0 and <= 1.", (Object[])new Object[]{killTaskSlotRatio});
        }
        this.killTaskSlotRatio = Builder.valueOrDefault(killTaskSlotRatio, 0.1);
        if (null != maxKillTaskSlots && maxKillTaskSlots < 0) {
            throw InvalidInput.exception((String)"maxKillTaskSlots [%d] is invalid. It must be >= 0.", (Object[])new Object[]{maxKillTaskSlots});
        }
        this.maxKillTaskSlots = Builder.valueOrDefault(maxKillTaskSlots, Integer.MAX_VALUE);
        this.dataSourcesToNotKillStalePendingSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(dataSourcesToNotKillStalePendingSegmentsIn);
        this.maxSegmentsInNodeLoadingQueue = Builder.valueOrDefault(maxSegmentsInNodeLoadingQueue, 500);
        this.decommissioningNodes = CoordinatorDynamicConfig.parseJsonStringOrArray(decommissioningNodes);
        this.pauseCoordination = pauseCoordination;
        this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
        this.useRoundRobinSegmentAssignment = Builder.valueOrDefault(useRoundRobinSegmentAssignment, true);
        this.debugDimensions = debugDimensions;
        this.validDebugDimensions = this.validateDebugDimensions(debugDimensions);
        this.turboLoadingNodes = (Set)Configs.valueOrDefault(turboLoadingNodes, Set.of());
    }

    private Map<Dimension, String> validateDebugDimensions(Map<String, String> debugDimensions) {
        EnumMap<Dimension, String> validDebugDimensions = new EnumMap<Dimension, String>(Dimension.class);
        if (debugDimensions == null || debugDimensions.isEmpty()) {
            return validDebugDimensions;
        }
        for (Dimension dimension : Dimension.values()) {
            String dimensionValue = debugDimensions.get(dimension.reportedName());
            if (dimensionValue == null) continue;
            validDebugDimensions.put(dimension, dimensionValue);
        }
        return validDebugDimensions;
    }

    private static Set<String> parseJsonStringOrArray(Object jsonStringOrArray) {
        if (jsonStringOrArray instanceof String) {
            String[] list = ((String)jsonStringOrArray).split(",");
            HashSet<String> result = new HashSet<String>();
            for (String item : list) {
                String trimmed = item.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
            return result;
        }
        if (jsonStringOrArray instanceof Collection) {
            return ImmutableSet.copyOf((Collection)((Collection)jsonStringOrArray));
        }
        return ImmutableSet.of();
    }

    public SegmentLoadingMode getLoadingModeForServer(String serverName) {
        return this.turboLoadingNodes.contains(serverName) ? SegmentLoadingMode.TURBO : SegmentLoadingMode.NORMAL;
    }

    @JsonProperty(value="millisToWaitBeforeDeleting")
    public long getMarkSegmentAsUnusedDelayMillis() {
        return this.markSegmentAsUnusedDelayMillis;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty(value="killDataSourceWhitelist")
    public Set<String> getSpecificDataSourcesToKillUnusedSegmentsIn() {
        return this.specificDataSourcesToKillUnusedSegmentsIn;
    }

    @JsonProperty(value="killTaskSlotRatio")
    public double getKillTaskSlotRatio() {
        return this.killTaskSlotRatio;
    }

    @JsonProperty(value="maxKillTaskSlots")
    public int getMaxKillTaskSlots() {
        return this.maxKillTaskSlots;
    }

    @JsonProperty(value="killPendingSegmentsSkipList")
    public Set<String> getDataSourcesToNotKillStalePendingSegmentsIn() {
        return this.dataSourcesToNotKillStalePendingSegmentsIn;
    }

    @JsonProperty
    public int getMaxSegmentsInNodeLoadingQueue() {
        return this.maxSegmentsInNodeLoadingQueue;
    }

    @JsonProperty
    public boolean isUseRoundRobinSegmentAssignment() {
        return this.useRoundRobinSegmentAssignment;
    }

    @JsonProperty
    public boolean isSmartSegmentLoading() {
        return this.smartSegmentLoading;
    }

    @JsonProperty
    public Set<String> getDecommissioningNodes() {
        return this.decommissioningNodes;
    }

    @JsonProperty
    public Map<String, String> getDebugDimensions() {
        return this.debugDimensions;
    }

    @JsonIgnore
    public Map<Dimension, String> getValidatedDebugDimensions() {
        return this.validDebugDimensions;
    }

    @JsonProperty
    public boolean getPauseCoordination() {
        return this.pauseCoordination;
    }

    @JsonProperty
    public boolean getReplicateAfterLoadTimeout() {
        return this.replicateAfterLoadTimeout;
    }

    @JsonProperty
    public Set<String> getTurboLoadingNodes() {
        return this.turboLoadingNodes;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments=" + this.markSegmentAsUnusedDelayMillis + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", specificDataSourcesToKillUnusedSegmentsIn=" + String.valueOf(this.specificDataSourcesToKillUnusedSegmentsIn) + ", killTaskSlotRatio=" + this.killTaskSlotRatio + ", maxKillTaskSlots=" + this.maxKillTaskSlots + ", dataSourcesToNotKillStalePendingSegmentsIn=" + String.valueOf(this.dataSourcesToNotKillStalePendingSegmentsIn) + ", maxSegmentsInNodeLoadingQueue=" + this.maxSegmentsInNodeLoadingQueue + ", decommissioningNodes=" + String.valueOf(this.decommissioningNodes) + ", pauseCoordination=" + this.pauseCoordination + ", replicateAfterLoadTimeout=" + this.replicateAfterLoadTimeout + ", turboLoadingNodes=" + String.valueOf(this.turboLoadingNodes) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        return this.markSegmentAsUnusedDelayMillis == that.markSegmentAsUnusedDelayMillis && this.maxSegmentsToMove == that.maxSegmentsToMove && this.balancerComputeThreads == that.balancerComputeThreads && this.replicantLifetime == that.replicantLifetime && this.replicationThrottleLimit == that.replicationThrottleLimit && this.replicateAfterLoadTimeout == that.replicateAfterLoadTimeout && this.maxSegmentsInNodeLoadingQueue == that.maxSegmentsInNodeLoadingQueue && this.useRoundRobinSegmentAssignment == that.useRoundRobinSegmentAssignment && this.pauseCoordination == that.pauseCoordination && Objects.equals(this.specificDataSourcesToKillUnusedSegmentsIn, that.specificDataSourcesToKillUnusedSegmentsIn) && Objects.equals(this.killTaskSlotRatio, that.killTaskSlotRatio) && Objects.equals(this.maxKillTaskSlots, that.maxKillTaskSlots) && Objects.equals(this.dataSourcesToNotKillStalePendingSegmentsIn, that.dataSourcesToNotKillStalePendingSegmentsIn) && Objects.equals(this.decommissioningNodes, that.decommissioningNodes) && Objects.equals(this.turboLoadingNodes, that.turboLoadingNodes) && Objects.equals(this.debugDimensions, that.debugDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.markSegmentAsUnusedDelayMillis, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.maxSegmentsInNodeLoadingQueue, this.specificDataSourcesToKillUnusedSegmentsIn, this.killTaskSlotRatio, this.maxKillTaskSlots, this.dataSourcesToNotKillStalePendingSegmentsIn, this.decommissioningNodes, this.pauseCoordination, this.debugDimensions, this.turboLoadingNodes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static int getDefaultBalancerComputeThreads() {
        return Math.min(Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2), 100);
    }

    private static class Defaults {
        static final long LEADING_MILLIS_BEFORE_MARK_UNUSED = TimeUnit.MINUTES.toMillis(15L);
        static final int MAX_SEGMENTS_TO_MOVE = 100;
        static final int REPLICANT_LIFETIME = 15;
        static final int REPLICATION_THROTTLE_LIMIT = 500;
        static final int MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 500;
        static final boolean PAUSE_COORDINATION = false;
        static final boolean REPLICATE_AFTER_LOAD_TIMEOUT = false;
        static final boolean USE_ROUND_ROBIN_ASSIGNMENT = true;
        static final boolean SMART_SEGMENT_LOADING = true;
        static final double KILL_TASK_SLOT_RATIO = 0.1;
        static final int MAX_KILL_TASK_SLOTS = Integer.MAX_VALUE;

        private Defaults() {
        }
    }

    public static class Builder {
        private Long markSegmentAsUnusedDelayMillis;
        private Integer maxSegmentsToMove;
        private Integer replicantLifetime;
        private Integer replicationThrottleLimit;
        private Integer balancerComputeThreads;
        private Object specificDataSourcesToKillUnusedSegmentsIn;
        private Double killTaskSlotRatio;
        private Integer maxKillTaskSlots;
        private Object dataSourcesToNotKillStalePendingSegmentsIn;
        private Integer maxSegmentsInNodeLoadingQueue;
        private Object decommissioningNodes;
        private Map<String, String> debugDimensions;
        private Boolean pauseCoordination;
        private Boolean replicateAfterLoadTimeout;
        private Boolean useRoundRobinSegmentAssignment;
        private Boolean smartSegmentLoading;
        private Set<String> turboLoadingNodes;

        public Builder() {
        }

        @JsonCreator
        public Builder(@JsonProperty(value="millisToWaitBeforeDeleting") @Nullable Long markSegmentAsUnusedDelayMillis, @JsonProperty(value="maxSegmentsToMove") @Nullable Integer maxSegmentsToMove, @JsonProperty(value="replicantLifetime") @Nullable Integer replicantLifetime, @JsonProperty(value="replicationThrottleLimit") @Nullable Integer replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") @Nullable Integer balancerComputeThreads, @JsonProperty(value="killDataSourceWhitelist") @Nullable Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killTaskSlotRatio") @Nullable Double killTaskSlotRatio, @JsonProperty(value="maxKillTaskSlots") @Nullable Integer maxKillTaskSlots, @JsonProperty(value="killPendingSegmentsSkipList") @Nullable Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") @Nullable Object decommissioningNodes, @JsonProperty(value="pauseCoordination") @Nullable Boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") @Nullable Boolean replicateAfterLoadTimeout, @JsonProperty(value="useRoundRobinSegmentAssignment") @Nullable Boolean useRoundRobinSegmentAssignment, @JsonProperty(value="smartSegmentLoading") @Nullable Boolean smartSegmentLoading, @JsonProperty(value="debugDimensions") @Nullable Map<String, String> debugDimensions, @JsonProperty(value="turboLoadingNodes") @Nullable Set<String> turboLoadingNodes) {
            this.markSegmentAsUnusedDelayMillis = markSegmentAsUnusedDelayMillis;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.balancerComputeThreads = balancerComputeThreads;
            this.specificDataSourcesToKillUnusedSegmentsIn = specificDataSourcesToKillUnusedSegmentsIn;
            this.killTaskSlotRatio = killTaskSlotRatio;
            this.maxKillTaskSlots = maxKillTaskSlots;
            this.dataSourcesToNotKillStalePendingSegmentsIn = dataSourcesToNotKillStalePendingSegmentsIn;
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            this.decommissioningNodes = decommissioningNodes;
            this.pauseCoordination = pauseCoordination;
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
            this.smartSegmentLoading = smartSegmentLoading;
            this.debugDimensions = debugDimensions;
            this.turboLoadingNodes = turboLoadingNodes;
        }

        public Builder withMarkSegmentAsUnusedDelayMillis(long leadingTimeMillis) {
            this.markSegmentAsUnusedDelayMillis = leadingTimeMillis;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withSmartSegmentLoading(boolean smartSegmentLoading) {
            this.smartSegmentLoading = smartSegmentLoading;
            return this;
        }

        public Builder withTurboLoadingNodes(Set<String> turboLoadingNodes) {
            this.turboLoadingNodes = turboLoadingNodes;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withSpecificDataSourcesToKillUnusedSegmentsIn(Set<String> dataSources) {
            this.specificDataSourcesToKillUnusedSegmentsIn = dataSources;
            return this;
        }

        public Builder withDatasourcesToNotKillPendingSegmentsIn(Set<String> datasources) {
            this.dataSourcesToNotKillStalePendingSegmentsIn = datasources;
            return this;
        }

        public Builder withKillTaskSlotRatio(Double killTaskSlotRatio) {
            this.killTaskSlotRatio = killTaskSlotRatio;
            return this;
        }

        public Builder withMaxKillTaskSlots(Integer maxKillTaskSlots) {
            this.maxKillTaskSlots = maxKillTaskSlots;
            return this;
        }

        public Builder withMaxSegmentsInNodeLoadingQueue(int maxSegmentsInNodeLoadingQueue) {
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            return this;
        }

        public Builder withDecommissioningNodes(Set<String> decommissioning) {
            this.decommissioningNodes = decommissioning;
            return this;
        }

        public Builder withPauseCoordination(boolean pauseCoordination) {
            this.pauseCoordination = pauseCoordination;
            return this;
        }

        public Builder withReplicateAfterLoadTimeout(boolean replicateAfterLoadTimeout) {
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            return this;
        }

        public Builder withUseRoundRobinSegmentAssignment(boolean useRoundRobinSegmentAssignment) {
            this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(Builder.valueOrDefault(this.markSegmentAsUnusedDelayMillis, Defaults.LEADING_MILLIS_BEFORE_MARK_UNUSED), Builder.valueOrDefault(this.maxSegmentsToMove, 100), Builder.valueOrDefault(this.replicantLifetime, 15), Builder.valueOrDefault(this.replicationThrottleLimit, 500), Builder.valueOrDefault(this.balancerComputeThreads, CoordinatorDynamicConfig.getDefaultBalancerComputeThreads()), this.specificDataSourcesToKillUnusedSegmentsIn, Builder.valueOrDefault(this.killTaskSlotRatio, 0.1), Builder.valueOrDefault(this.maxKillTaskSlots, Integer.MAX_VALUE), this.dataSourcesToNotKillStalePendingSegmentsIn, Builder.valueOrDefault(this.maxSegmentsInNodeLoadingQueue, 500), this.decommissioningNodes, Builder.valueOrDefault(this.pauseCoordination, false), Builder.valueOrDefault(this.replicateAfterLoadTimeout, false), Builder.valueOrDefault(this.useRoundRobinSegmentAssignment, true), Builder.valueOrDefault(this.smartSegmentLoading, true), this.debugDimensions, this.turboLoadingNodes);
        }

        private static <T> T valueOrDefault(@Nullable T value, @NotNull T defaultValue) {
            return value == null ? defaultValue : value;
        }

        public CoordinatorDynamicConfig build(CoordinatorDynamicConfig defaults) {
            return new CoordinatorDynamicConfig(Builder.valueOrDefault(this.markSegmentAsUnusedDelayMillis, defaults.getMarkSegmentAsUnusedDelayMillis()), Builder.valueOrDefault(this.maxSegmentsToMove, defaults.getMaxSegmentsToMove()), Builder.valueOrDefault(this.replicantLifetime, defaults.getReplicantLifetime()), Builder.valueOrDefault(this.replicationThrottleLimit, defaults.getReplicationThrottleLimit()), Builder.valueOrDefault(this.balancerComputeThreads, defaults.getBalancerComputeThreads()), Builder.valueOrDefault(this.specificDataSourcesToKillUnusedSegmentsIn, defaults.getSpecificDataSourcesToKillUnusedSegmentsIn()), Builder.valueOrDefault(this.killTaskSlotRatio, defaults.killTaskSlotRatio), Builder.valueOrDefault(this.maxKillTaskSlots, defaults.maxKillTaskSlots), Builder.valueOrDefault(this.dataSourcesToNotKillStalePendingSegmentsIn, defaults.getDataSourcesToNotKillStalePendingSegmentsIn()), Builder.valueOrDefault(this.maxSegmentsInNodeLoadingQueue, defaults.getMaxSegmentsInNodeLoadingQueue()), Builder.valueOrDefault(this.decommissioningNodes, defaults.getDecommissioningNodes()), Builder.valueOrDefault(this.pauseCoordination, defaults.getPauseCoordination()), Builder.valueOrDefault(this.replicateAfterLoadTimeout, defaults.getReplicateAfterLoadTimeout()), Builder.valueOrDefault(this.useRoundRobinSegmentAssignment, defaults.isUseRoundRobinSegmentAssignment()), Builder.valueOrDefault(this.smartSegmentLoading, defaults.isSmartSegmentLoading()), Builder.valueOrDefault(this.debugDimensions, defaults.getDebugDimensions()), Builder.valueOrDefault(this.turboLoadingNodes, defaults.getTurboLoadingNodes()));
        }
    }
}

