/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.MetadataAction;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;

public class RunRules
implements CoordinatorDuty {
    private static final EmittingLogger log = new EmittingLogger(RunRules.class);
    private final MetadataAction.DeleteSegments deleteHandler;
    private final MetadataAction.GetDatasourceRules ruleHandler;

    public RunRules(MetadataAction.DeleteSegments deleteHandler, MetadataAction.GetDatasourceRules ruleHandler) {
        this.deleteHandler = deleteHandler;
        this.ruleHandler = ruleHandler;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Cluster has no servers. Not running any rules.", new Object[0]);
            return params;
        }
        TreeSet<DataSegment> usedSegments = params.getUsedSegmentsNewestFirst();
        ImmutableSet<DataSegment> overshadowed = params.getDataSourcesSnapshot().getOvershadowedSegments();
        StrategicSegmentAssigner segmentAssigner = params.getSegmentAssigner();
        DateTime now = DateTimes.nowUtc();
        Object2IntOpenHashMap datasourceToSegmentsWithNoRule = new Object2IntOpenHashMap();
        for (DataSegment segment : usedSegments) {
            if (overshadowed.contains(segment)) continue;
            List<Rule> rules = this.ruleHandler.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                rule.run(segment, segmentAssigner);
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            datasourceToSegmentsWithNoRule.addTo((Object)segment.getDataSource(), 1);
        }
        this.processSegmentDeletes(segmentAssigner, params.getCoordinatorStats());
        this.alertForSegmentsWithNoRules((Object2IntOpenHashMap<String>)datasourceToSegmentsWithNoRule);
        this.alertForInvalidRules(segmentAssigner);
        return params.buildFromExisting().withBroadcastDatasources(this.getBroadcastDatasources(params)).build();
    }

    private void processSegmentDeletes(StrategicSegmentAssigner segmentAssigner, CoordinatorRunStats runStats) {
        segmentAssigner.getSegmentsToDelete().forEach((datasource, segmentIds) -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int numUpdatedSegments = this.deleteHandler.markSegmentsAsUnused((String)datasource, (Set<SegmentId>)segmentIds);
            RowKey rowKey = RowKey.of(Dimension.DATASOURCE, datasource);
            runStats.add(Stats.Segments.DELETED, rowKey, numUpdatedSegments);
            log.info("Successfully marked [%d] segments of datasource[%s] as unused in [%d]ms.", new Object[]{numUpdatedSegments, datasource, stopwatch.millisElapsed()});
        });
    }

    private void alertForSegmentsWithNoRules(Object2IntOpenHashMap<String> datasourceToSegmentsWithNoRule) {
        datasourceToSegmentsWithNoRule.object2IntEntrySet().fastForEach(entry -> log.noStackTrace().makeAlert("No matching retention rule for [%d] segments in datasource[%s]", new Object[]{entry.getIntValue(), entry.getKey()}).emit());
    }

    private void alertForInvalidRules(StrategicSegmentAssigner segmentAssigner) {
        segmentAssigner.getDatasourceToInvalidLoadTiers().forEach((datasource, invalidTiers) -> log.makeAlert("Load rules for datasource[%s] refer to invalid tiers[%s]. Update the load rules or add servers for these tiers.", new Object[]{datasource, invalidTiers}).emit());
    }

    private Set<String> getBroadcastDatasources(DruidCoordinatorRuntimeParams params) {
        return params.getDataSourcesSnapshot().getDataSourcesMap().values().stream().map(ImmutableDruidDataSource::getName).filter(this::isBroadcastDatasource).collect(Collectors.toSet());
    }

    private boolean isBroadcastDatasource(String datasource) {
        return this.ruleHandler.getRulesWithDefault(datasource).stream().anyMatch(rule -> rule instanceof BroadcastDistributionRule);
    }
}

