/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.config.HttpLoadQueuePeonConfig;
import org.apache.druid.server.coordinator.loading.HttpLoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;

public class LoadQueueTaskMaster {
    private static final Logger log = new Logger(LoadQueueTaskMaster.class);
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService peonExec;
    private final ExecutorService callbackExec;
    private final HttpLoadQueuePeonConfig config;
    private final HttpClient httpClient;
    private final Supplier<CoordinatorDynamicConfig> coordinatorDynamicConfigSupplier;
    @GuardedBy(value="this")
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, LoadQueuePeon> loadManagementPeons = new ConcurrentHashMap();

    public LoadQueueTaskMaster(ObjectMapper jsonMapper, ScheduledExecutorService peonExec, ExecutorService callbackExec, HttpLoadQueuePeonConfig config, HttpClient httpClient, Supplier<CoordinatorDynamicConfig> coordinatorDynamicConfigSupplier) {
        this.jsonMapper = jsonMapper;
        this.peonExec = peonExec;
        this.callbackExec = callbackExec;
        this.config = config;
        this.httpClient = httpClient;
        this.coordinatorDynamicConfigSupplier = coordinatorDynamicConfigSupplier;
    }

    private LoadQueuePeon createPeon(ImmutableDruidServer server) {
        return new HttpLoadQueuePeon(server.getURL(), this.jsonMapper, this.httpClient, this.config, () -> this.coordinatorDynamicConfigSupplier.get().getLoadingModeForServer(server.getName()), this.peonExec, this.callbackExec);
    }

    public Map<String, LoadQueuePeon> getAllPeons() {
        return this.loadManagementPeons;
    }

    public LoadQueuePeon getPeonForServer(ImmutableDruidServer server) {
        return this.loadManagementPeons.get(server.getName());
    }

    public synchronized void resetPeonsForNewServers(List<ImmutableDruidServer> currentServers) {
        if (!this.isLeader.get()) {
            return;
        }
        HashSet oldServers = Sets.newHashSet((Iterable)this.loadManagementPeons.keySet());
        for (ImmutableDruidServer server : currentServers) {
            this.loadManagementPeons.computeIfAbsent(server.getName(), serverName -> {
                LoadQueuePeon loadQueuePeon = this.createPeon(server);
                loadQueuePeon.start();
                log.debug("Created LoadQueuePeon for server[%s].", new Object[]{server.getName()});
                return loadQueuePeon;
            });
        }
        for (ImmutableDruidServer server : currentServers) {
            oldServers.remove(server.getName());
        }
        for (String name : oldServers) {
            log.debug("Removing LoadQueuePeon for disappeared server[%s].", new Object[]{name});
            LoadQueuePeon peon = this.loadManagementPeons.remove(name);
            peon.stop();
        }
    }

    public synchronized void onLeaderStart() {
        this.isLeader.set(true);
    }

    public synchronized void onLeaderStop() {
        this.isLeader.set(false);
        log.info("Stopping load queue peon for [%d] servers.", new Object[]{this.loadManagementPeons.size()});
        this.loadManagementPeons.values().forEach(LoadQueuePeon::stop);
        this.loadManagementPeons.clear();
    }

    public boolean isHttpLoading() {
        return true;
    }
}

