/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class LimitRequestsFilter
implements Filter {
    private final int maxActiveRequests;
    private final AtomicInteger activeRequestsCount = new AtomicInteger();

    public LimitRequestsFilter(int maxActiveRequests) {
        Preconditions.checkArgument((maxActiveRequests > 0 && maxActiveRequests < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"maxActiveRequests must be > 0 and < Integer.MAX_VALUE.");
        this.maxActiveRequests = maxActiveRequests;
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int curr = this.activeRequestsCount.incrementAndGet();
        try {
            if (curr <= this.maxActiveRequests) {
                chain.doFilter(request, response);
            } else {
                ((HttpServletResponse)response).sendError(429, "Too Many Requests");
            }
        }
        finally {
            this.activeRequestsCount.decrementAndGet();
        }
    }

    public void destroy() {
    }

    public int getActiveRequestsCount() {
        return this.activeRequestsCount.get();
    }
}

