/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class GroupingSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.GROUPING;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        GroupingAggregatorFactory factory;
        List arguments = aggregateCall.getArgList().stream().map(i -> this.getColumnName(plannerContext, inputAccessor.getInputRowSignature(), inputAccessor.getProject(), virtualColumnRegistry, inputAccessor.getRexBuilder().getTypeFactory(), (int)i)).filter(Objects::nonNull).collect(Collectors.toList());
        if (arguments.size() < aggregateCall.getArgList().size()) {
            return null;
        }
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory2 : existing.getAggregatorFactories()) {
                GroupingAggregatorFactory groupingFactory;
                if (!(factory2 instanceof GroupingAggregatorFactory) || !(groupingFactory = (GroupingAggregatorFactory)factory2).getGroupings().equals(arguments) || !groupingFactory.getName().equals(name)) continue;
                return Aggregation.create((AggregatorFactory)groupingFactory);
            }
        }
        try {
            factory = new GroupingAggregatorFactory(name, arguments);
        }
        catch (Exception e) {
            plannerContext.setPlanningError("Initialisation of Grouping Aggregator Factory in case of [%s] threw [%s]", aggregateCall, e.getMessage());
            return null;
        }
        return Aggregation.create((AggregatorFactory)factory);
    }

    @Nullable
    private String getColumnName(PlannerContext plannerContext, RowSignature rowSignature, Project project, VirtualColumnRegistry virtualColumnRegistry, RelDataTypeFactory typeFactory, int fieldNumber) {
        RexNode node = Expressions.fromFieldAccess(typeFactory, rowSignature, project, fieldNumber);
        if (null == node) {
            return null;
        }
        DruidExpression expression = Expressions.toDruidExpression(plannerContext, rowSignature, node);
        if (null == expression) {
            return null;
        }
        if (expression.isDirectColumnAccess()) {
            return expression.getDirectColumn();
        }
        if (expression.isSimpleExtraction()) {
            return expression.getSimpleExtraction().getColumn();
        }
        return virtualColumnRegistry.getOrCreateVirtualColumnForExpression(expression, node.getType());
    }
}

