/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.http;

import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.druid.catalog.sync.CatalogUpdateListener;
import org.apache.druid.catalog.sync.UpdateEvent;
import org.apache.druid.server.http.security.ConfigResourceFilter;

@Path(value="/druid/broker/v1/catalog")
public class CatalogListenerResource {
    public static final String BASE_URL = "/druid/broker/v1/catalog";
    public static final String SYNC_URL = "/sync";
    private final CatalogUpdateListener listener;

    @Inject
    public CatalogListenerResource(CatalogUpdateListener listener) {
        this.listener = listener;
    }

    @POST
    @Path(value="/sync")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response syncTable(UpdateEvent event) {
        this.listener.updated(event);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="flush")
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response flush() {
        this.listener.flush();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="resync")
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response resync() {
        this.listener.resync();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }
}

