/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs.tasklog;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;
import org.apache.druid.tasklogs.TaskLogs;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HdfsTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(HdfsTaskLogs.class);
    private final HdfsTaskLogsConfig config;
    private final Configuration hadoopConfig;

    @Inject
    public HdfsTaskLogs(HdfsTaskLogsConfig config, @Hdfs Configuration hadoopConfig) {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
    }

    public void pushTaskLog(String taskId, File logFile) throws IOException {
        Path path = this.getTaskLogFileFromId(taskId);
        log.info("Writing task log to: %s", new Object[]{path});
        this.pushTaskFile(path, logFile);
        log.info("Wrote task log to: %s", new Object[]{path});
    }

    public void pushTaskReports(String taskId, File reportFile) throws IOException {
        Path path = this.getTaskReportsFileFromId(taskId);
        log.info("Writing task reports to: %s", new Object[]{path});
        this.pushTaskFile(path, reportFile);
        log.info("Wrote task reports to: %s", new Object[]{path});
    }

    public void pushTaskStatus(String taskId, File statusFile) throws IOException {
        Path path = this.getTaskStatusFileFromId(taskId);
        log.info("Writing task status to: %s", new Object[]{path});
        this.pushTaskFile(path, statusFile);
        log.info("Wrote task status to: %s", new Object[]{path});
    }

    private void pushTaskFile(Path path, File logFile) throws IOException {
        FileSystem fs = path.getFileSystem(this.hadoopConfig);
        try (FileInputStream in = new FileInputStream(logFile);
             FSDataOutputStream out = fs.create(path, true);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
    }

    public Optional<InputStream> streamTaskLog(String taskId, long offset) throws IOException {
        Path path = this.getTaskLogFileFromId(taskId);
        return this.streamTaskFile(path, offset);
    }

    public Optional<InputStream> streamTaskReports(String taskId) throws IOException {
        Path path = this.getTaskReportsFileFromId(taskId);
        return this.streamTaskFile(path, 0L);
    }

    public Optional<InputStream> streamTaskStatus(String taskId) throws IOException {
        Path path = this.getTaskStatusFileFromId(taskId);
        return this.streamTaskFile(path, 0L);
    }

    private Optional<InputStream> streamTaskFile(Path path, long offset) throws IOException {
        FileSystem fs = path.getFileSystem(this.hadoopConfig);
        if (fs.exists(path)) {
            long seekPos;
            log.info("Reading task log from: %s", new Object[]{path});
            if (offset < 0L) {
                FileStatus stat = fs.getFileStatus(path);
                seekPos = Math.max(0L, stat.getLen() + offset);
            } else {
                seekPos = offset;
            }
            FSDataInputStream inputStream = fs.open(path);
            inputStream.seek(seekPos);
            log.info("Read task log from: %s (seek = %,d)", new Object[]{path, seekPos});
            return Optional.of((Object)inputStream);
        }
        return Optional.absent();
    }

    private Path getTaskLogFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_')));
    }

    private Path getTaskReportsFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_') + ".reports.json"));
    }

    private Path getTaskStatusFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_') + ".status.json"));
    }

    private static String mergePaths(String path1, String path2) {
        return path1 + (path1.endsWith("/") ? "" : "/") + path2;
    }

    public void killAll() throws IOException {
        log.info("Deleting all task logs from hdfs dir [%s].", new Object[]{this.config.getDirectory()});
        Path taskLogDir = new Path(this.config.getDirectory());
        FileSystem fs = taskLogDir.getFileSystem(this.hadoopConfig);
        fs.delete(taskLogDir, true);
    }

    public void killOlderThan(long timestamp) throws IOException {
        Path taskLogDir = new Path(this.config.getDirectory());
        FileSystem fs = taskLogDir.getFileSystem(this.hadoopConfig);
        if (fs.exists(taskLogDir)) {
            FileStatus taskLogFileStatus = fs.getFileStatus(taskLogDir);
            if (!taskLogFileStatus.isDirectory()) {
                throw new IOE("taskLogDir [%s] must be a directory.", new Object[]{taskLogDir});
            }
            RemoteIterator iter = fs.listLocatedStatus(taskLogDir);
            while (iter.hasNext()) {
                LocatedFileStatus file = (LocatedFileStatus)iter.next();
                if (file.getModificationTime() < timestamp) {
                    Path p = file.getPath();
                    log.info("Deleting hdfs task log [%s].", new Object[]{p.toUri().toString()});
                    fs.delete(p, true);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new IOException(new InterruptedException("Thread interrupted. Couldn't delete all tasklogs."));
            }
        }
    }

    public void pushTaskPayload(String taskId, File taskPayloadFile) throws IOException {
        Path path = this.getTaskPayloadFileFromId(taskId);
        log.info("Pushing payload for task[%s] to location[%s]", new Object[]{taskId, path});
        this.pushTaskFile(path, taskPayloadFile);
    }

    public Optional<InputStream> streamTaskPayload(String taskId) throws IOException {
        Path path = this.getTaskPayloadFileFromId(taskId);
        return this.streamTaskFile(path, 0L);
    }

    private Path getTaskPayloadFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_') + ".payload.json"));
    }
}

