/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1JobConditionBuilder;
import io.kubernetes.client.openapi.models.V1JobConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1JobStatus;
import io.kubernetes.client.openapi.models.V1JobStatusFluent;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPods;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPodsBuilder;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPodsFluentImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1JobStatusFluentImpl<A extends V1JobStatusFluent<A>>
extends BaseFluent<A>
implements V1JobStatusFluent<A> {
    private Integer active;
    private String completedIndexes;
    private OffsetDateTime completionTime;
    private ArrayList<V1JobConditionBuilder> conditions;
    private Integer failed;
    private Integer ready;
    private OffsetDateTime startTime;
    private Integer succeeded;
    private V1UncountedTerminatedPodsBuilder uncountedTerminatedPods;

    public V1JobStatusFluentImpl() {
    }

    public V1JobStatusFluentImpl(V1JobStatus instance) {
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withCompletedIndexes(instance.getCompletedIndexes());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withFailed(instance.getFailed());
            this.withReady(instance.getReady());
            this.withStartTime(instance.getStartTime());
            this.withSucceeded(instance.getSucceeded());
            this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
        }
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null;
    }

    @Override
    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    @Override
    public A withCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return (A)this;
    }

    @Override
    public Boolean hasCompletedIndexes() {
        return this.completedIndexes != null;
    }

    @Override
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1JobCondition ... items) {
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1JobCondition> items) {
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1JobConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1JobCondition> getConditions() {
        return this.conditions != null ? V1JobStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1JobCondition> buildConditions() {
        return this.conditions != null ? V1JobStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1JobCondition buildMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> addNewConditionLike(V1JobCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1JobCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public Boolean hasFailed() {
        return this.failed != null;
    }

    @Override
    public Integer getReady() {
        return this.ready;
    }

    @Override
    public A withReady(Integer ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    @Override
    public Boolean hasSucceeded() {
        return this.succeeded != null;
    }

    @Override
    @Deprecated
    public V1UncountedTerminatedPods getUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    @Override
    public V1UncountedTerminatedPods buildUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    @Override
    public A withUncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
        if (uncountedTerminatedPods != null) {
            this.uncountedTerminatedPods = new V1UncountedTerminatedPodsBuilder(uncountedTerminatedPods);
            this._visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);
        } else {
            this.uncountedTerminatedPods = null;
            this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null;
    }

    @Override
    public V1JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
        return new UncountedTerminatedPodsNestedImpl();
    }

    @Override
    public V1JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(V1UncountedTerminatedPods item) {
        return new UncountedTerminatedPodsNestedImpl(item);
    }

    @Override
    public V1JobStatusFluent.UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods());
    }

    @Override
    public V1JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods() != null ? this.getUncountedTerminatedPods() : new V1UncountedTerminatedPodsBuilder().build());
    }

    @Override
    public V1JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(V1UncountedTerminatedPods item) {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods() != null ? this.getUncountedTerminatedPods() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1JobStatusFluentImpl that = (V1JobStatusFluentImpl)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.completedIndexes, that.completedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failed, that.failed)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.succeeded, that.succeeded)) {
            return false;
        }
        return Objects.equals(this.uncountedTerminatedPods, that.uncountedTerminatedPods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.ready, this.startTime, this.succeeded, this.uncountedTerminatedPods, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.completedIndexes != null) {
            sb.append("completedIndexes:");
            sb.append(this.completedIndexes + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded + ",");
        }
        if (this.uncountedTerminatedPods != null) {
            sb.append("uncountedTerminatedPods:");
            sb.append(this.uncountedTerminatedPods);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1JobConditionFluentImpl<V1JobStatusFluent.ConditionsNested<N>>
    implements V1JobStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1JobConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, V1JobCondition item) {
            this.index = index;
            this.builder = new V1JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1JobConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1JobStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class UncountedTerminatedPodsNestedImpl<N>
    extends V1UncountedTerminatedPodsFluentImpl<V1JobStatusFluent.UncountedTerminatedPodsNested<N>>
    implements V1JobStatusFluent.UncountedTerminatedPodsNested<N>,
    Nested<N> {
        V1UncountedTerminatedPodsBuilder builder;

        UncountedTerminatedPodsNestedImpl(V1UncountedTerminatedPods item) {
            this.builder = new V1UncountedTerminatedPodsBuilder(this, item);
        }

        UncountedTerminatedPodsNestedImpl() {
            this.builder = new V1UncountedTerminatedPodsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1JobStatusFluentImpl.this.withUncountedTerminatedPods(this.builder.build());
        }

        @Override
        public N endUncountedTerminatedPods() {
            return this.and();
        }
    }
}

