/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcList;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;

class OrcStructConverter {
    private final boolean binaryAsString;
    private Object2IntMap<String> fieldIndexCache;

    @Nonnull
    private static List<Object> convertList(TypeDescription fieldDescription, OrcList orcList, boolean binaryAsString) {
        TypeDescription listType = (TypeDescription)fieldDescription.getChildren().get(0);
        if (listType.getCategory().isPrimitive()) {
            return orcList.stream().map(li -> OrcStructConverter.convertPrimitive(listType, (WritableComparable)li, binaryAsString)).collect(Collectors.toList());
        }
        return new ArrayList<Object>((Collection<Object>)orcList);
    }

    private Map<Object, Object> convertMap(TypeDescription fieldDescription, OrcMap<? extends WritableComparable, ? extends WritableComparable> map, boolean binaryAsString) {
        HashMap<Object, Object> converted = new HashMap<Object, Object>();
        TypeDescription keyDescription = (TypeDescription)fieldDescription.getChildren().get(0);
        TypeDescription valueDescription = (TypeDescription)fieldDescription.getChildren().get(1);
        for (WritableComparable key : map.navigableKeySet()) {
            Object newKey = OrcStructConverter.convertPrimitive(keyDescription, key, binaryAsString);
            converted.put(newKey, this.convertField(valueDescription, (WritableComparable)map.get((Object)key)));
        }
        return converted;
    }

    @Nullable
    private static Object convertPrimitive(TypeDescription fieldDescription, @Nullable WritableComparable field, boolean binaryAsString) {
        if (field == null) {
            return null;
        }
        switch (fieldDescription.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return ((Text)field).toString();
            }
            case BOOLEAN: {
                return ((BooleanWritable)field).get();
            }
            case BYTE: {
                return ((ByteWritable)field).get();
            }
            case SHORT: {
                return ((ShortWritable)field).get();
            }
            case INT: {
                return ((IntWritable)field).get();
            }
            case LONG: {
                return ((LongWritable)field).get();
            }
            case FLOAT: {
                return Float.valueOf(((FloatWritable)field).get());
            }
            case DOUBLE: {
                return ((DoubleWritable)field).get();
            }
            case DECIMAL: {
                return ((HiveDecimalWritable)field).getHiveDecimal().doubleValue();
            }
            case TIMESTAMP: {
                return ((OrcTimestamp)field).getTime();
            }
            case DATE: {
                return DateTimes.utc((long)((DateWritable)field).get().getTime());
            }
            case BINARY: {
                byte[] bytes = ((BytesWritable)field).getBytes();
                if (binaryAsString) {
                    return StringUtils.fromUtf8((byte[])bytes);
                }
                return bytes;
            }
        }
        return null;
    }

    @Nullable
    public Object tryConvertPrimitive(@Nullable WritableComparable field) {
        if (field == null) {
            return null;
        }
        if (field instanceof Text) {
            return ((Text)field).toString();
        }
        if (field instanceof BooleanWritable) {
            return ((BooleanWritable)field).get();
        }
        if (field instanceof ByteWritable) {
            return ((ByteWritable)field).get();
        }
        if (field instanceof ShortWritable) {
            return ((ShortWritable)field).get();
        }
        if (field instanceof IntWritable) {
            return ((IntWritable)field).get();
        }
        if (field instanceof LongWritable) {
            return ((LongWritable)field).get();
        }
        if (field instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)field).get());
        }
        if (field instanceof DoubleWritable) {
            return ((DoubleWritable)field).get();
        }
        if (field instanceof HiveDecimalWritable) {
            return ((HiveDecimalWritable)field).getHiveDecimal().doubleValue();
        }
        if (field instanceof OrcTimestamp) {
            return ((OrcTimestamp)field).getTime();
        }
        if (field instanceof DateWritable) {
            return DateTimes.utc((long)((DateWritable)field).get().getTime());
        }
        if (field instanceof BytesWritable) {
            byte[] bytes = ((BytesWritable)field).getBytes();
            if (this.binaryAsString) {
                return StringUtils.fromUtf8((byte[])bytes);
            }
            return bytes;
        }
        return null;
    }

    OrcStructConverter(boolean binaryAsString) {
        this.binaryAsString = binaryAsString;
    }

    @Nullable
    Object convertRootField(OrcStruct struct, String fieldName) {
        TypeDescription schema = struct.getSchema();
        List fields = schema.getFieldNames();
        if (this.fieldIndexCache == null) {
            this.fieldIndexCache = new Object2IntOpenHashMap(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                this.fieldIndexCache.put((Object)((String)fields.get(i)), i);
            }
        }
        int fieldIndex = this.fieldIndexCache.getOrDefault((Object)fieldName, -1);
        return this.convertField(struct, fieldIndex);
    }

    @Nullable
    Object convertField(OrcStruct struct, int fieldIndex) {
        if (fieldIndex < 0) {
            return null;
        }
        TypeDescription schema = struct.getSchema();
        TypeDescription fieldDescription = (TypeDescription)schema.getChildren().get(fieldIndex);
        WritableComparable fieldValue = struct.getFieldValue(fieldIndex);
        if (fieldValue == null) {
            return null;
        }
        return this.convertField(fieldDescription, fieldValue);
    }

    @Nullable
    Object convertField(TypeDescription fieldDescription, WritableComparable fieldValue) {
        if (fieldDescription.getCategory().isPrimitive()) {
            return OrcStructConverter.convertPrimitive(fieldDescription, fieldValue, this.binaryAsString);
        }
        switch (fieldDescription.getCategory()) {
            case LIST: {
                OrcList orcList = (OrcList)fieldValue;
                return OrcStructConverter.convertList(fieldDescription, orcList, this.binaryAsString);
            }
            case MAP: {
                OrcMap map = (OrcMap)fieldValue;
                return this.convertMap(fieldDescription, (OrcMap<? extends WritableComparable, ? extends WritableComparable>)map, this.binaryAsString);
            }
            case STRUCT: {
                OrcStruct structMap = (OrcStruct)fieldValue;
                return this.convertStructToMap(structMap);
            }
        }
        return null;
    }

    private Map<String, Object> convertStructToMap(OrcStruct map) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        List fieldNames = map.getSchema().getFieldNames();
        for (int i = 0; i < fieldNames.size(); ++i) {
            converted.put((String)fieldNames.get(i), this.convertField(map, i));
        }
        return converted;
    }
}

