/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class RetrieveUnusedSegmentsAction
implements TaskAction<List<DataSegment>> {
    private final String dataSource;
    private final Interval interval;
    private final List<String> versions;
    private final Integer limit;
    private final DateTime maxUsedStatusLastUpdatedTime;

    @JsonCreator
    public RetrieveUnusedSegmentsAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="versions") @Nullable List<String> versions, @JsonProperty(value="limit") @Nullable Integer limit, @JsonProperty(value="maxUsedStatusLastUpdatedTime") @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        this.dataSource = dataSource;
        this.interval = interval;
        this.versions = versions;
        this.limit = limit;
        this.maxUsedStatusLastUpdatedTime = maxUsedStatusLastUpdatedTime;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public List<String> getVersions() {
        return this.versions;
    }

    @Nullable
    @JsonProperty
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    @JsonProperty
    public DateTime getMaxUsedStatusLastUpdatedTime() {
        return this.maxUsedStatusLastUpdatedTime;
    }

    @Override
    public TypeReference<List<DataSegment>> getReturnTypeReference() {
        return new TypeReference<List<DataSegment>>(){};
    }

    @Override
    public List<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().retrieveUnusedSegmentsForInterval(this.dataSource, this.interval, this.versions, this.limit, this.maxUsedStatusLastUpdatedTime);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + "', interval=" + this.interval + ", versions=" + this.versions + ", limit=" + this.limit + ", maxUsedStatusLastUpdatedTime=" + this.maxUsedStatusLastUpdatedTime + "}";
    }
}

