/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.AggregateFunction;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.LagBasedAutoScaler;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LagBasedAutoScalerConfig
implements AutoScalerConfig {
    private final long lagCollectionIntervalMillis;
    private final long lagCollectionRangeMillis;
    private final long scaleActionStartDelayMillis;
    private final long scaleActionPeriodMillis;
    private final long scaleOutThreshold;
    private final long scaleInThreshold;
    private final double triggerScaleOutFractionThreshold;
    private final double triggerScaleInFractionThreshold;
    private int taskCountMax;
    private int taskCountMin;
    private Integer taskCountStart;
    private final int scaleInStep;
    private final int scaleOutStep;
    private final boolean enableTaskAutoScaler;
    private final long minTriggerScaleActionFrequencyMillis;
    private final AggregateFunction lagAggregate;
    private final Double stopTaskCountRatio;

    @JsonCreator
    public LagBasedAutoScalerConfig(@Nullable @JsonProperty(value="lagCollectionIntervalMillis") Long lagCollectionIntervalMillis, @Nullable @JsonProperty(value="lagCollectionRangeMillis") Long lagCollectionRangeMillis, @Nullable @JsonProperty(value="scaleActionStartDelayMillis") Long scaleActionStartDelayMillis, @Nullable @JsonProperty(value="scaleActionPeriodMillis") Long scaleActionPeriodMillis, @Nullable @JsonProperty(value="scaleOutThreshold") Long scaleOutThreshold, @Nullable @JsonProperty(value="scaleInThreshold") Long scaleInThreshold, @Nullable @JsonProperty(value="triggerScaleOutFractionThreshold") Double triggerScaleOutFractionThreshold, @Nullable @JsonProperty(value="triggerScaleInFractionThreshold") Double triggerScaleInFractionThreshold, @JsonProperty(value="taskCountMax") Integer taskCountMax, @Nullable @JsonProperty(value="taskCountStart") Integer taskCountStart, @JsonProperty(value="taskCountMin") Integer taskCountMin, @Nullable @JsonProperty(value="scaleInStep") Integer scaleInStep, @Nullable @JsonProperty(value="scaleOutStep") Integer scaleOutStep, @Nullable @JsonProperty(value="enableTaskAutoScaler") Boolean enableTaskAutoScaler, @Nullable @JsonProperty(value="minTriggerScaleActionFrequencyMillis") Long minTriggerScaleActionFrequencyMillis, @Nullable @JsonProperty(value="lagAggregate") AggregateFunction lagAggregate, @Nullable @JsonProperty(value="stopTaskCountRatio") Double stopTaskCountRatio) {
        this.enableTaskAutoScaler = enableTaskAutoScaler != null ? enableTaskAutoScaler : false;
        this.lagCollectionIntervalMillis = lagCollectionIntervalMillis != null ? lagCollectionIntervalMillis : 30000L;
        this.lagCollectionRangeMillis = lagCollectionRangeMillis != null ? lagCollectionRangeMillis : 600000L;
        this.scaleActionStartDelayMillis = scaleActionStartDelayMillis != null ? scaleActionStartDelayMillis : 300000L;
        this.scaleActionPeriodMillis = scaleActionPeriodMillis != null ? scaleActionPeriodMillis : 60000L;
        this.scaleOutThreshold = scaleOutThreshold != null ? scaleOutThreshold : 6000000L;
        this.scaleInThreshold = scaleInThreshold != null ? scaleInThreshold : 1000000L;
        this.triggerScaleOutFractionThreshold = triggerScaleOutFractionThreshold != null ? triggerScaleOutFractionThreshold : 0.3;
        this.triggerScaleInFractionThreshold = triggerScaleInFractionThreshold != null ? triggerScaleInFractionThreshold : 0.9;
        this.lagAggregate = lagAggregate;
        if (this.enableTaskAutoScaler) {
            if (taskCountMax == null || taskCountMin == null) {
                throw new RuntimeException("taskCountMax or taskCountMin can't be null!");
            }
            if (taskCountMax < taskCountMin) {
                throw new RuntimeException("taskCountMax can't lower than taskCountMin!");
            }
            if (taskCountStart != null && (taskCountStart > taskCountMax || taskCountStart < taskCountMin)) {
                throw new RuntimeException("taskCountMin <= taskCountStart <= taskCountMax");
            }
            this.taskCountMax = taskCountMax;
            this.taskCountMin = taskCountMin;
            this.taskCountStart = taskCountStart;
        }
        this.scaleInStep = scaleInStep != null ? scaleInStep : 1;
        this.scaleOutStep = scaleOutStep != null ? scaleOutStep : 2;
        this.minTriggerScaleActionFrequencyMillis = minTriggerScaleActionFrequencyMillis != null ? minTriggerScaleActionFrequencyMillis : 600000L;
        Preconditions.checkArgument((stopTaskCountRatio == null || stopTaskCountRatio > 0.0 && stopTaskCountRatio <= 1.0 ? 1 : 0) != 0, (Object)"0.0 < stopTaskCountRatio <= 1.0");
        this.stopTaskCountRatio = stopTaskCountRatio;
    }

    @JsonProperty
    public long getLagCollectionIntervalMillis() {
        return this.lagCollectionIntervalMillis;
    }

    @JsonProperty
    public long getLagCollectionRangeMillis() {
        return this.lagCollectionRangeMillis;
    }

    @JsonProperty
    public long getScaleActionStartDelayMillis() {
        return this.scaleActionStartDelayMillis;
    }

    @JsonProperty
    public long getScaleActionPeriodMillis() {
        return this.scaleActionPeriodMillis;
    }

    @JsonProperty
    public long getScaleOutThreshold() {
        return this.scaleOutThreshold;
    }

    @JsonProperty
    public long getScaleInThreshold() {
        return this.scaleInThreshold;
    }

    @JsonProperty
    public double getTriggerScaleOutFractionThreshold() {
        return this.triggerScaleOutFractionThreshold;
    }

    @JsonProperty
    public double getTriggerScaleInFractionThreshold() {
        return this.triggerScaleInFractionThreshold;
    }

    @Override
    @JsonProperty
    public int getTaskCountMax() {
        return this.taskCountMax;
    }

    @Override
    @JsonProperty
    public int getTaskCountMin() {
        return this.taskCountMin;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTaskCountStart() {
        return this.taskCountStart;
    }

    @Override
    public SupervisorTaskAutoScaler createAutoScaler(Supervisor supervisor, SupervisorSpec spec, ServiceEmitter emitter) {
        return new LagBasedAutoScaler((SeekableStreamSupervisor)supervisor, spec.getId(), this, spec, emitter);
    }

    @JsonProperty
    public int getScaleInStep() {
        return this.scaleInStep;
    }

    @JsonProperty
    public int getScaleOutStep() {
        return this.scaleOutStep;
    }

    @Override
    @JsonProperty
    public boolean getEnableTaskAutoScaler() {
        return this.enableTaskAutoScaler;
    }

    @Override
    @JsonProperty
    public long getMinTriggerScaleActionFrequencyMillis() {
        return this.minTriggerScaleActionFrequencyMillis;
    }

    @JsonProperty
    @Nullable
    public AggregateFunction getLagAggregate() {
        return this.lagAggregate;
    }

    @Override
    @JsonProperty
    @Nullable
    public Double getStopTaskCountRatio() {
        return this.stopTaskCountRatio;
    }

    public String toString() {
        return "autoScalerConfig{enableTaskAutoScaler=" + this.enableTaskAutoScaler + ", taskCountMax=" + this.taskCountMax + ", taskCountMin=" + this.taskCountMin + ", taskCountStart=" + this.taskCountStart + ", minTriggerScaleActionFrequencyMillis=" + this.minTriggerScaleActionFrequencyMillis + ", lagCollectionIntervalMillis=" + this.lagCollectionIntervalMillis + ", lagCollectionIntervalMillis=" + this.lagCollectionIntervalMillis + ", scaleOutThreshold=" + this.scaleOutThreshold + ", triggerScaleOutFractionThreshold=" + this.triggerScaleOutFractionThreshold + ", scaleInThreshold=" + this.scaleInThreshold + ", triggerScaleInFractionThreshold=" + this.triggerScaleInFractionThreshold + ", scaleActionStartDelayMillis=" + this.scaleActionStartDelayMillis + ", scaleActionPeriodMillis=" + this.scaleActionPeriodMillis + ", scaleInStep=" + this.scaleInStep + ", scaleOutStep=" + this.scaleOutStep + ", lagAggregate=" + this.lagAggregate + ", stopTaskCountRatio=" + this.stopTaskCountRatio + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LagBasedAutoScalerConfig that = (LagBasedAutoScalerConfig)o;
        return this.lagCollectionIntervalMillis == that.lagCollectionIntervalMillis && this.lagCollectionRangeMillis == that.lagCollectionRangeMillis && this.scaleActionStartDelayMillis == that.scaleActionStartDelayMillis && this.scaleActionPeriodMillis == that.scaleActionPeriodMillis && this.scaleOutThreshold == that.scaleOutThreshold && this.scaleInThreshold == that.scaleInThreshold && Double.compare(that.triggerScaleOutFractionThreshold, this.triggerScaleOutFractionThreshold) == 0 && Double.compare(that.triggerScaleInFractionThreshold, this.triggerScaleInFractionThreshold) == 0 && this.taskCountMax == that.taskCountMax && this.taskCountMin == that.taskCountMin && this.scaleInStep == that.scaleInStep && this.scaleOutStep == that.scaleOutStep && this.enableTaskAutoScaler == that.enableTaskAutoScaler && this.minTriggerScaleActionFrequencyMillis == that.minTriggerScaleActionFrequencyMillis && Objects.equals(this.taskCountStart, that.taskCountStart) && this.lagAggregate == that.lagAggregate && Objects.equals(this.stopTaskCountRatio, that.stopTaskCountRatio);
    }

    public int hashCode() {
        return Objects.hash(this.lagCollectionIntervalMillis, this.lagCollectionRangeMillis, this.scaleActionStartDelayMillis, this.scaleActionPeriodMillis, this.scaleOutThreshold, this.scaleInThreshold, this.triggerScaleOutFractionThreshold, this.triggerScaleInFractionThreshold, this.taskCountMax, this.taskCountMin, this.taskCountStart, this.scaleInStep, this.scaleOutStep, this.enableTaskAutoScaler, this.minTriggerScaleActionFrequencyMillis, this.lagAggregate, this.stopTaskCountRatio);
    }
}

