/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.druid.indexing.worker.TaskAnnouncement;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="taskUpdate", value=TaskUpdate.class), @JsonSubTypes.Type(name="taskRemoval", value=TaskRemoval.class), @JsonSubTypes.Type(name="metadata", value=Metadata.class)})
public interface WorkerHistoryItem {

    public static class Metadata
    implements WorkerHistoryItem {
        private final boolean disabled;

        @JsonCreator
        public Metadata(@JsonProperty(value="disabled") boolean disabled) {
            this.disabled = disabled;
        }

        @JsonProperty
        public boolean isDisabled() {
            return this.disabled;
        }

        public String toString() {
            return "Metadata{disabled=" + this.disabled + "}";
        }
    }

    public static class TaskRemoval
    implements WorkerHistoryItem {
        private final String taskId;

        @JsonCreator
        public TaskRemoval(@JsonProperty(value="taskId") String taskId) {
            this.taskId = taskId;
        }

        @JsonProperty
        public String getTaskId() {
            return this.taskId;
        }

        public String toString() {
            return "TaskRemoval{taskId='" + this.taskId + "'}";
        }
    }

    public static class TaskUpdate
    implements WorkerHistoryItem {
        private final TaskAnnouncement taskAnnouncement;

        @JsonCreator
        public TaskUpdate(@JsonProperty(value="taskAnnouncement") TaskAnnouncement taskAnnouncement) {
            this.taskAnnouncement = taskAnnouncement;
        }

        @JsonProperty
        public TaskAnnouncement getTaskAnnouncement() {
            return this.taskAnnouncement;
        }

        public String toString() {
            return "TaskUpdate{taskAnnouncement=" + this.taskAnnouncement + "}";
        }
    }
}

