/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.AllocationMetricCollector;

class AllocationMetricCollectors {
    private static final Logger log = new Logger(AllocationMetricCollectors.class);
    private static Method getThreadAllocatedBytes;
    private static ThreadMXBean threadMXBean;
    private static boolean initialized;

    AllocationMetricCollectors() {
    }

    @Nullable
    static AllocationMetricCollector getAllocationMetricCollector() {
        if (initialized) {
            return new AllocationMetricCollector(getThreadAllocatedBytes, threadMXBean);
        }
        return null;
    }

    static {
        initialized = false;
        try {
            threadMXBean = ManagementFactory.getThreadMXBean();
            getThreadAllocatedBytes = threadMXBean.getClass().getMethod("getThreadAllocatedBytes", long[].class);
            getThreadAllocatedBytes.setAccessible(true);
            getThreadAllocatedBytes.invoke((Object)threadMXBean, new Object[]{threadMXBean.getAllThreadIds()});
            initialized = true;
        }
        catch (Exception e) {
            log.warn(e, "Cannot initialize %s", AllocationMetricCollector.class.getName());
        }
    }
}

