/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalVector;

public class ExprEvalBindingVector<T>
implements ExprEvalVector<T> {
    private final ExpressionType expressionType;
    private final Expr.VectorInputBinding bindings;
    private final String bindingName;
    @Nullable
    private long[] longs;
    @Nullable
    private double[] doubles;
    @Nullable
    private boolean[] numericNulls;
    private Object[] objects;

    public ExprEvalBindingVector(ExpressionType expressionType, Expr.VectorInputBinding bindings, String name) {
        this.expressionType = expressionType;
        this.bindings = bindings;
        this.bindingName = name;
    }

    @Override
    public ExpressionType getType() {
        return this.expressionType;
    }

    @Override
    public T values() {
        if (this.expressionType.is(ExprType.LONG)) {
            return (T)this.getLongVector();
        }
        if (this.expressionType.is(ExprType.DOUBLE)) {
            return (T)this.getDoubleVector();
        }
        return (T)this.bindings.getObjectVector(this.bindingName);
    }

    @Override
    public long[] getLongVector() {
        if (this.expressionType.isNumeric()) {
            this.longs = this.bindings.getLongVector(this.bindingName);
        } else {
            this.computeNumbers();
        }
        return this.longs;
    }

    @Override
    public double[] getDoubleVector() {
        if (this.expressionType.isNumeric()) {
            this.doubles = this.bindings.getDoubleVector(this.bindingName);
        } else {
            this.computeNumbers();
        }
        return this.doubles;
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        if (this.expressionType.isNumeric()) {
            this.numericNulls = this.bindings.getNullVector(this.bindingName);
        } else {
            this.computeNumbers();
        }
        return this.numericNulls;
    }

    @Override
    public Object[] getObjectVector() {
        if (this.expressionType.is(ExprType.LONG)) {
            long[] values = this.bindings.getLongVector(this.bindingName);
            boolean[] nulls = this.bindings.getNullVector(this.bindingName);
            this.objects = new Long[values.length];
            if (nulls != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.objects[i] = nulls[i] ? null : Long.valueOf(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    this.objects[i] = values[i];
                }
            }
        } else if (this.expressionType.is(ExprType.DOUBLE)) {
            double[] values = this.bindings.getDoubleVector(this.bindingName);
            boolean[] nulls = this.bindings.getNullVector(this.bindingName);
            this.objects = new Double[values.length];
            if (nulls != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.objects[i] = nulls[i] ? null : Double.valueOf(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    this.objects[i] = values[i];
                }
            }
        } else {
            this.objects = this.bindings.getObjectVector(this.bindingName);
        }
        return this.objects;
    }

    @Override
    public boolean elementAsBoolean(int index) {
        if (this.expressionType.is(ExprType.LONG)) {
            if (this.longs == null) {
                this.getLongVector();
            }
            if (this.numericNulls != null && this.numericNulls[index]) {
                return Evals.asBoolean(0L);
            }
            return Evals.asBoolean(this.longs[index]);
        }
        if (this.expressionType.is(ExprType.DOUBLE)) {
            if (this.doubles == null) {
                this.getDoubleVector();
            }
            if (this.numericNulls != null && this.numericNulls[index]) {
                return Evals.asBoolean(0.0);
            }
            return Evals.asBoolean(this.doubles[index]);
        }
        if (this.objects == null) {
            this.getObjectVector();
        }
        if (this.expressionType.is(ExprType.STRING)) {
            return Evals.asBoolean((String)this.objects[index]);
        }
        return ExprEval.ofType(this.expressionType, this.objects[index]).asBoolean();
    }

    private void computeNumbers() {
        Object[] values = this.getObjectVector();
        if (this.longs == null) {
            this.longs = new long[values.length];
            this.doubles = new double[values.length];
            this.numericNulls = new boolean[values.length];
            boolean isString = this.expressionType.is(ExprType.STRING);
            for (int i = 0; i < values.length; ++i) {
                if (isString) {
                    Number n = ExprEval.computeNumber(Evals.asString(values[i]));
                    if (n != null) {
                        this.longs[i] = n.longValue();
                        this.doubles[i] = n.doubleValue();
                        this.numericNulls[i] = false;
                        continue;
                    }
                    this.longs[i] = 0L;
                    this.doubles[i] = 0.0;
                    this.numericNulls[i] = true;
                    continue;
                }
                ExprEval<?> valueEval = ExprEval.ofType(this.expressionType, values[i]);
                this.longs[i] = valueEval.asLong();
                this.doubles[i] = valueEval.asDouble();
                this.numericNulls[i] = valueEval.isNumericNull();
            }
        }
    }
}

