/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.join.JoinPrefixUtils;

public class JoinDataSourceAnalysis {
    private final DataSource baseDataSource;
    @Nullable
    private final DimFilter joinBaseTableFilter;
    private final List<PreJoinableClause> preJoinableClauses;

    public JoinDataSourceAnalysis(DataSource baseDataSource, @Nullable Query<?> baseQuery, @Nullable DimFilter joinBaseTableFilter, List<PreJoinableClause> preJoinableClauses, @Nullable QuerySegmentSpec querySegmentSpec) {
        if (baseDataSource instanceof JoinDataSource) {
            throw new IAE("Base dataSource cannot be a join! Original base datasource was: %s", baseDataSource);
        }
        this.baseDataSource = baseDataSource;
        this.joinBaseTableFilter = joinBaseTableFilter;
        this.preJoinableClauses = preJoinableClauses;
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public Optional<DimFilter> getJoinBaseTableFilter() {
        return Optional.ofNullable(this.joinBaseTableFilter);
    }

    public List<PreJoinableClause> getPreJoinableClauses() {
        return this.preJoinableClauses;
    }

    public boolean isBaseColumn(String column) {
        for (PreJoinableClause clause : this.preJoinableClauses) {
            if (!JoinPrefixUtils.isPrefixedBy(column, clause.getPrefix())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinDataSourceAnalysis that = (JoinDataSourceAnalysis)o;
        return Objects.equals(this.baseDataSource, that.baseDataSource);
    }

    public int hashCode() {
        return Objects.hash(this.baseDataSource);
    }

    public String toString() {
        return "DataSourceAnalysis{, baseDataSource=" + this.baseDataSource + ", preJoinableClauses=" + this.preJoinableClauses + "}";
    }

    public static JoinDataSourceAnalysis constructAnalysis(JoinDataSource dataSource) {
        DataSource current = dataSource;
        DimFilter currentDimFilter = TrueDimFilter.instance();
        ArrayList<PreJoinableClause> preJoinableClauses = new ArrayList<PreJoinableClause>();
        while (current instanceof JoinDataSource) {
            JoinDataSource joinDataSource = current;
            currentDimFilter = DimFilters.conjunction(currentDimFilter, joinDataSource.getLeftFilter());
            PreJoinableClause e = new PreJoinableClause(joinDataSource);
            preJoinableClauses.add(e);
            current = joinDataSource.getLeft();
        }
        if (currentDimFilter == TrueDimFilter.instance()) {
            currentDimFilter = null;
        }
        Collections.reverse(preJoinableClauses);
        return new JoinDataSourceAnalysis(current, null, currentDimFilter, preJoinableClauses, null);
    }
}

