/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.sql;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimateWithErrorBounds;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.segment.column.TypeSignature;

public class ThetaPostAggMacros {
    public static final String THETA_SKETCH_ESTIMATE = "theta_sketch_estimate";
    public static final String THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS = "theta_sketch_estimate_with_error_bounds";
    public static final ExpressionType THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS_TYPE = ExpressionType.fromColumnType((TypeSignature)SketchModule.MERGE_TYPE);

    public static class ThetaSketchEstimateWithErrorBoundsExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private Expr estimateExpr;
        private Expr numStdDev;

        public ThetaSketchEstimateWithErrorBoundsExpr(ThetaSketchEstimateWithErrorBoundsExprMacro macro, List<Expr> args) {
            super((ExprMacroTable.ExprMacro)macro, args);
            this.estimateExpr = args.get(0);
            this.numStdDev = args.get(1);
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            int numStdDevs = this.numStdDev.eval(bindings).asInt();
            ExprEval eval = this.estimateExpr.eval(bindings);
            Object valObj = eval.value();
            if (valObj == null) {
                return ExprEval.ofComplex((ExpressionType)THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS_TYPE, (Object)new SketchEstimateWithErrorBounds(0.0, 0.0, 0.0, numStdDevs));
            }
            if (valObj instanceof SketchHolder) {
                SketchHolder thetaSketchHolder = (SketchHolder)valObj;
                return ExprEval.ofComplex((ExpressionType)THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS_TYPE, (Object)thetaSketchHolder.getEstimateWithErrorBounds(numStdDevs));
            }
            throw new IllegalArgumentException("requires a ThetaSketch as the argument");
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS_TYPE;
        }
    }

    public static class ThetaSketchEstimateExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private Expr estimateExpr;

        public ThetaSketchEstimateExpr(ThetaSketchEstimateExprMacro macro, List<Expr> args) {
            super((ExprMacroTable.ExprMacro)macro, args);
            this.estimateExpr = (Expr)Iterables.getOnlyElement(args);
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = this.estimateExpr.eval(bindings);
            Object valObj = eval.value();
            if (valObj == null) {
                return ExprEval.ofDouble(null);
            }
            if (valObj instanceof SketchHolder) {
                SketchHolder thetaSketchHolder = (SketchHolder)valObj;
                double estimate = thetaSketchHolder.getEstimate();
                return ExprEval.of((double)estimate);
            }
            throw new IllegalArgumentException("requires a ThetaSketch as the argument");
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.DOUBLE;
        }
    }

    public static class ThetaSketchEstimateWithErrorBoundsExprMacro
    implements ExprMacroTable.ExprMacro {
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 2);
            return new ThetaSketchEstimateWithErrorBoundsExpr(this, args);
        }

        public String name() {
            return ThetaPostAggMacros.THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS;
        }
    }

    public static class ThetaSketchEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            return new ThetaSketchEstimateExpr(this, args);
        }

        public String name() {
            return ThetaPostAggMacros.THETA_SKETCH_ESTIMATE;
        }
    }
}

