/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.errors;

import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Set;

public class ParseOptionIllegalValueException
extends ParseRestrictionViolatedException {
    private static final long serialVersionUID = 810812151673279427L;
    private final String optionName;
    private final String optionTitle;
    private final Object illegalValue;
    private final Set<Object> allowedValues;

    public ParseOptionIllegalValueException(String optionName, String optionTitle, Object value, Set<Object> allowedValues) {
        super("Value for option %s value '%s' was given as '%s' which is not in the list of allowed values: %s", optionName, optionTitle, value, allowedValues);
        this.optionName = optionName;
        this.optionTitle = optionTitle;
        this.illegalValue = value;
        this.allowedValues = AirlineUtils.unmodifiableSetCopy(allowedValues);
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionTitle() {
        return this.optionTitle;
    }

    public Object getIllegalValue() {
        return this.illegalValue;
    }

    public Set<Object> getAllowedValues() {
        return this.allowedValues;
    }
}

