/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterable;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;

public class AzureUtils {
    @VisibleForTesting
    static final String AZURE_STORAGE_HOST_ADDRESS = "blob.core.windows.net";
    static final String BLOB = "blob";
    static final String AZURE_STORAGE_HADOOP_PROTOCOL = "wasbs";
    public static final Predicate<Throwable> AZURE_RETRY = e -> {
        if (e == null) {
            return false;
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (t instanceof BlobStorageException) {
                int statusCode = ((BlobStorageException)t).getStatusCode();
                return statusCode == 429 || statusCode == 500 || statusCode == 503;
            }
            if (t instanceof IOException) {
                return true;
            }
            if (!(t instanceof TimeoutException)) continue;
            return true;
        }
        return false;
    };

    public static String extractAzureKey(URI uri) {
        return StringUtils.maybeRemoveLeadingSlash((String)uri.getPath());
    }

    public static String maybeRemoveAzurePathPrefix(String blobPath, String blobStorageEndpointSuffix) {
        boolean blobPathIsHadoop = blobPath.contains(blobStorageEndpointSuffix);
        if (blobPathIsHadoop) {
            return blobPath.substring(blobPath.indexOf(blobStorageEndpointSuffix) + blobStorageEndpointSuffix.length() + 1);
        }
        return blobPath;
    }

    public static void deleteObjectsInPath(AzureStorage storage, AzureInputDataConfig config, AzureAccountConfig accountConfig, AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, String bucket, String prefix, Predicate<CloudBlobHolder> filter) {
        AzureCloudBlobIterable azureCloudBlobIterable = azureCloudBlobIterableFactory.create((Iterable<URI>)ImmutableList.of((Object)new CloudObjectLocation(bucket, prefix).toUri("azure")), config.getMaxListingLength(), storage);
        for (CloudBlobHolder nextObject : azureCloudBlobIterable) {
            if (!filter.apply((Object)nextObject)) continue;
            storage.emptyCloudBlobDirectory(nextObject.getContainerName(), nextObject.getName(), accountConfig.getMaxTries());
        }
    }
}

