/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskStorageDirTracker;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerUtils;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.EmittingLogger;

public abstract class BaseRestorableTaskRunner<WorkItemType extends TaskRunnerWorkItem>
implements TaskRunner {
    protected static final EmittingLogger LOG = new EmittingLogger(BaseRestorableTaskRunner.class);
    protected static final String TASK_RESTORE_FILENAME = "restore.json";
    protected final CopyOnWriteArrayList<Pair<TaskRunnerListener, Executor>> listeners = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<String, WorkItemType> tasks = new ConcurrentHashMap();
    protected final ObjectMapper jsonMapper;
    protected final TaskConfig taskConfig;
    private final TaskStorageDirTracker tracker;

    public BaseRestorableTaskRunner(ObjectMapper jsonMapper, TaskConfig taskConfig, TaskStorageDirTracker tracker) {
        this.jsonMapper = jsonMapper;
        this.taskConfig = taskConfig;
        this.tracker = tracker;
    }

    protected TaskStorageDirTracker getTracker() {
        return this.tracker;
    }

    @Override
    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
        TaskRestoreInfo taskRestoreInfo;
        File restoreFile = this.getRestoreFile();
        if (restoreFile.exists()) {
            try {
                taskRestoreInfo = (TaskRestoreInfo)this.jsonMapper.readValue(restoreFile, TaskRestoreInfo.class);
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Failed to read restorable tasks from file[%s]. Skipping restore.", new Object[]{restoreFile});
                return ImmutableList.of();
            }
        } else {
            return ImmutableList.of();
        }
        ArrayList<Pair<Task, ListenableFuture<TaskStatus>>> retVal = new ArrayList<Pair<Task, ListenableFuture<TaskStatus>>>();
        Map<String, TaskStorageDirTracker.StorageSlot> existingTaskDirs = this.tracker.findExistingTaskDirs(taskRestoreInfo.getRunningTasks());
        for (String taskId : taskRestoreInfo.getRunningTasks()) {
            TaskStorageDirTracker.StorageSlot storageSlot = existingTaskDirs.get(taskId);
            if (storageSlot == null) {
                LOG.warn("restorable task [%s] didn't actually exist!?", new Object[]{taskId});
                continue;
            }
            try {
                File taskFile = storageSlot.getDirectory().toPath().resolve(taskId).resolve("task.json").toFile();
                Task task = (Task)this.jsonMapper.readValue(taskFile, Task.class);
                if (!task.getId().equals(taskId)) {
                    throw new ISE("Task [%s] restore file had wrong id[%s]", new Object[]{taskId, task.getId()});
                }
                if (this.taskConfig.isRestoreTasksOnRestart() && task.canRestore()) {
                    LOG.info("Restoring task[%s].", new Object[]{task.getId()});
                    retVal.add((Pair<Task, ListenableFuture<TaskStatus>>)Pair.of((Object)task, this.run(task)));
                    continue;
                }
                File dir = new File(storageSlot.getDirectory(), taskId);
                LOG.info("Task [%s] is not restorable, cleaning up the directory [%s]", new Object[]{taskId, dir});
                this.tracker.returnStorageSlot(storageSlot);
                FileUtils.deleteDirectory((File)dir);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "Failed to restore task[%s]. Trying to restore other tasks.", new Object[]{taskId});
            }
        }
        if (!retVal.isEmpty()) {
            LOG.info("Restored [%,d] tasks: [%s]", new Object[]{retVal.size(), Joiner.on((String)", ").join(retVal)});
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(TaskRunnerListener listener, Executor executor) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listener.getListenerId())) continue;
            throw new ISE("Listener [%s] already registered", new Object[]{listener.getListenerId()});
        }
        Pair listenerPair = Pair.of((Object)listener, (Object)executor);
        ConcurrentHashMap<String, WorkItemType> concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            for (TaskRunnerWorkItem item : this.tasks.values()) {
                TaskRunnerUtils.notifyLocationChanged((Iterable<Pair<TaskRunnerListener, Executor>>)ImmutableList.of((Object)listenerPair), item.getTaskId(), item.getLocation());
            }
            this.listeners.add((Pair<TaskRunnerListener, Executor>)listenerPair);
            LOG.debug("Registered listener [%s]", new Object[]{listener.getListenerId()});
        }
    }

    @Override
    public void unregisterListener(String listenerId) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listenerId)) continue;
            this.listeners.remove(pair);
            LOG.debug("Unregistered listener [%s]", new Object[]{listenerId});
            return;
        }
    }

    public abstract Collection<TaskRunnerWorkItem> getRunningTasks();

    public abstract Collection<TaskRunnerWorkItem> getPendingTasks();

    @Override
    @Nullable
    public abstract RunnerTaskState getRunnerTaskState(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskRunnerWorkItem> getKnownTasks() {
        ConcurrentHashMap<String, WorkItemType> concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            return Lists.newArrayList(this.tasks.values());
        }
    }

    @GuardedBy(value="tasks")
    protected void saveRunningTasks() {
        File restoreFile = this.getRestoreFile();
        ArrayList<String> theTasks = new ArrayList<String>();
        for (TaskRunnerWorkItem forkingTaskRunnerWorkItem : this.tasks.values()) {
            theTasks.add(forkingTaskRunnerWorkItem.getTaskId());
        }
        try {
            Files.createParentDirs((File)restoreFile);
            this.jsonMapper.writeValue(restoreFile, (Object)new TaskRestoreInfo(theTasks));
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Failed to save tasks to restore file[%s]. Skipping this save.", new Object[]{restoreFile});
        }
    }

    protected File getRestoreFile() {
        return new File(this.taskConfig.getBaseTaskDir(), TASK_RESTORE_FILENAME);
    }

    protected static class TaskRestoreInfo {
        @JsonProperty
        private final List<String> runningTasks;

        @JsonCreator
        public TaskRestoreInfo(@JsonProperty(value="runningTasks") List<String> runningTasks) {
            this.runningTasks = runningTasks;
        }

        public List<String> getRunningTasks() {
            return this.runningTasks;
        }
    }
}

