/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.EbsOptimizedInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EbsOptimizedInfoStaxUnmarshaller
implements Unmarshaller<EbsOptimizedInfo, StaxUnmarshallerContext> {
    private static EbsOptimizedInfoStaxUnmarshaller instance;

    public EbsOptimizedInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        EbsOptimizedInfo ebsOptimizedInfo = new EbsOptimizedInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return ebsOptimizedInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("baselineBandwidthInMbps", targetDepth)) {
                    ebsOptimizedInfo.setBaselineBandwidthInMbps(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("baselineThroughputInMBps", targetDepth)) {
                    ebsOptimizedInfo.setBaselineThroughputInMBps(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("baselineIops", targetDepth)) {
                    ebsOptimizedInfo.setBaselineIops(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumBandwidthInMbps", targetDepth)) {
                    ebsOptimizedInfo.setMaximumBandwidthInMbps(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumThroughputInMBps", targetDepth)) {
                    ebsOptimizedInfo.setMaximumThroughputInMBps(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("maximumIops", targetDepth)) continue;
                ebsOptimizedInfo.setMaximumIops(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return ebsOptimizedInfo;
    }

    public static EbsOptimizedInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EbsOptimizedInfoStaxUnmarshaller();
        }
        return instance;
    }
}

