/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.vector.VectorMatch;

public class FilteredVectorInputBinding
implements Expr.VectorInputBinding {
    private Expr.VectorInputBinding delegate;
    private final Map<String, Object[]> cachedObjects;
    private final Map<String, long[]> cachedLongs;
    private final Map<String, double[]> cachedDoubles;
    private final Map<String, boolean[]> cachedNulls;
    private final VectorMatch vectorMatch;

    public FilteredVectorInputBinding(int maxVectorSize) {
        int[] match = new int[maxVectorSize];
        for (int i = 0; i < maxVectorSize; ++i) {
            match[i] = i;
        }
        this.vectorMatch = VectorMatch.wrap(match);
        this.cachedObjects = new HashMap<String, Object[]>();
        this.cachedLongs = new HashMap<String, long[]>();
        this.cachedDoubles = new HashMap<String, double[]>();
        this.cachedNulls = new HashMap<String, boolean[]>();
    }

    public void setBindings(Expr.VectorInputBinding bindings) {
        this.delegate = bindings;
    }

    public VectorMatch getVectorMatch() {
        return this.vectorMatch;
    }

    @Override
    @Nullable
    public ExpressionType getType(String name) {
        return this.delegate.getType(name);
    }

    @Override
    public int getMaxVectorSize() {
        return this.delegate.getMaxVectorSize();
    }

    @Override
    public Object[] getObjectVector(String name) {
        Object[] baseVector = this.delegate.getObjectVector(name);
        Object[] matchVector = this.cachedObjects.computeIfAbsent(name, k -> new Object[this.delegate.getMaxVectorSize()]);
        int[] selection = this.vectorMatch.getSelection();
        for (int i = 0; i < this.vectorMatch.getSelectionSize(); ++i) {
            matchVector[i] = baseVector[selection[i]];
        }
        return matchVector;
    }

    @Override
    public long[] getLongVector(String name) {
        long[] baseVector = this.delegate.getLongVector(name);
        long[] matchVector = this.cachedLongs.computeIfAbsent(name, k -> new long[this.delegate.getMaxVectorSize()]);
        int[] selection = this.vectorMatch.getSelection();
        for (int i = 0; i < this.vectorMatch.getSelectionSize(); ++i) {
            matchVector[i] = baseVector[selection[i]];
        }
        return matchVector;
    }

    @Override
    public double[] getDoubleVector(String name) {
        double[] baseVector = this.delegate.getDoubleVector(name);
        double[] matchVector = this.cachedDoubles.computeIfAbsent(name, k -> new double[this.delegate.getMaxVectorSize()]);
        int[] selection = this.vectorMatch.getSelection();
        for (int i = 0; i < this.vectorMatch.getSelectionSize(); ++i) {
            matchVector[i] = baseVector[selection[i]];
        }
        return matchVector;
    }

    @Override
    @Nullable
    public boolean[] getNullVector(String name) {
        boolean[] baseVector = this.delegate.getNullVector(name);
        if (baseVector == null) {
            return null;
        }
        boolean[] matchVector = this.cachedNulls.computeIfAbsent(name, k -> new boolean[this.delegate.getMaxVectorSize()]);
        int[] selection = this.vectorMatch.getSelection();
        for (int i = 0; i < this.vectorMatch.getSelectionSize(); ++i) {
            matchVector[i] = baseVector[selection[i]];
        }
        return matchVector;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.vectorMatch.getSelectionSize();
    }

    @Override
    public int getCurrentVectorId() {
        return this.delegate.getCurrentVectorId();
    }
}

