/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;

public class CapabilitiesBasedFormat
implements ColumnFormat {
    @VisibleForTesting
    public static final ColumnCapabilities.CoercionLogic DIMENSION_CAPABILITY_MERGE_LOGIC = new ColumnCapabilities.CoercionLogic(){

        @Override
        public boolean dictionaryEncoded() {
            return true;
        }

        @Override
        public boolean dictionaryValuesSorted() {
            return true;
        }

        @Override
        public boolean dictionaryValuesUnique() {
            return true;
        }

        @Override
        public boolean multipleValues() {
            return false;
        }

        @Override
        public boolean hasNulls() {
            return false;
        }
    };
    private final ColumnCapabilities capabilities;

    public static CapabilitiesBasedFormat forColumnIndexer(ColumnCapabilities capabilities) {
        return new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.snapshot(capabilities, DIMENSION_CAPABILITY_MERGE_LOGIC));
    }

    public CapabilitiesBasedFormat(ColumnCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public DimensionHandler getColumnHandler(String columnName) {
        return DimensionHandlerUtils.getHandlerFromCapabilities(columnName, this.capabilities, null);
    }

    @Override
    public DimensionSchema getColumnSchema(String columnName) {
        return this.getColumnHandler(columnName).getDimensionSchema(this.capabilities);
    }

    @Override
    public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
        String otherType;
        if (otherFormat == null) {
            return this;
        }
        ColumnCapabilitiesImpl merged = ColumnCapabilitiesImpl.copyOf(this.toColumnCapabilities());
        ColumnCapabilitiesImpl otherSnapshot = ColumnCapabilitiesImpl.copyOf(otherFormat.toColumnCapabilities());
        String mergedType = merged.getType() == null ? null : merged.asTypeString();
        String string = otherType = otherSnapshot.getType() == null ? null : otherSnapshot.asTypeString();
        if (!Objects.equals(merged.getType(), otherSnapshot.getType()) || !Objects.equals(merged.getElementType(), otherSnapshot.getElementType())) {
            throw new ISE("Cannot merge columns of type[%s] and [%s]", mergedType, otherType);
        }
        if (!Objects.equals(merged.getComplexTypeName(), otherSnapshot.getComplexTypeName())) {
            throw new ISE("Cannot merge columns of type[%s] and [%s]", mergedType, otherType);
        }
        merged.setDictionaryEncoded(merged.isDictionaryEncoded().or(otherSnapshot.isDictionaryEncoded()).isTrue());
        merged.setHasMultipleValues(merged.hasMultipleValues().or(otherSnapshot.hasMultipleValues()).isTrue());
        merged.setDictionaryValuesSorted(merged.areDictionaryValuesSorted().and(otherSnapshot.areDictionaryValuesSorted()).isTrue());
        merged.setDictionaryValuesUnique(merged.areDictionaryValuesUnique().and(otherSnapshot.areDictionaryValuesUnique()).isTrue());
        merged.setHasNulls(merged.hasNulls().or(otherSnapshot.hasNulls()).isTrue());
        if (merged.hasBitmapIndexes() != otherSnapshot.hasBitmapIndexes()) {
            merged.setHasBitmapIndexes(false);
        }
        if (merged.hasSpatialIndexes() != otherSnapshot.hasSpatialIndexes()) {
            merged.setHasSpatialIndexes(merged.hasSpatialIndexes() || otherSnapshot.hasSpatialIndexes());
        }
        return new CapabilitiesBasedFormat(merged);
    }

    @Override
    public ColumnType getLogicalType() {
        return this.capabilities.toColumnType();
    }

    @Override
    public ColumnCapabilities toColumnCapabilities() {
        return this.capabilities;
    }
}

