/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.utils.CircularBuffer;

public class ParseExceptionHandler {
    private static final Logger LOG = new Logger(ParseExceptionHandler.class);
    private final RowIngestionMeters rowIngestionMeters;
    private final boolean logParseExceptions;
    private final int maxAllowedParseExceptions;
    @Nullable
    private final CircularBuffer<ParseExceptionReport> savedParseExceptionReports;

    public ParseExceptionHandler(RowIngestionMeters rowIngestionMeters, boolean logParseExceptions, int maxAllowedParseExceptions, int maxSavedParseExceptions) {
        this.rowIngestionMeters = (RowIngestionMeters)Preconditions.checkNotNull((Object)rowIngestionMeters, (Object)"rowIngestionMeters");
        this.logParseExceptions = logParseExceptions;
        this.maxAllowedParseExceptions = maxAllowedParseExceptions;
        this.savedParseExceptionReports = maxSavedParseExceptions > 0 ? new CircularBuffer(maxSavedParseExceptions) : null;
    }

    public void handle(@Nullable ParseException e) {
        if (e == null) {
            return;
        }
        if (e.isFromPartiallyValidRow()) {
            this.rowIngestionMeters.incrementProcessedWithError();
        } else {
            this.rowIngestionMeters.incrementUnparseable();
        }
        this.logParseExceptionHelper(e);
        if (this.savedParseExceptionReports != null) {
            ParseExceptionReport parseExceptionReport = new ParseExceptionReport(e.getInput(), e.isFromPartiallyValidRow() ? "processedWithError" : "unparseable", (List<String>)(e.isFromPartiallyValidRow() ? ((UnparseableColumnsParseException)e).getColumnExceptionMessages() : ImmutableList.of((Object)e.getMessage())), e.getTimeOfExceptionMillis());
            this.savedParseExceptionReports.add(parseExceptionReport);
        }
        if (this.rowIngestionMeters.getUnparseable() + this.rowIngestionMeters.getProcessedWithError() > (long)this.maxAllowedParseExceptions) {
            throw new RE("Max parse exceptions[%s] exceeded", this.maxAllowedParseExceptions);
        }
    }

    @Nullable
    public List<ParseExceptionReport> getSavedParseExceptionReports() {
        if (this.savedParseExceptionReports == null) {
            return null;
        }
        ArrayList<ParseExceptionReport> reports = new ArrayList<ParseExceptionReport>();
        for (int i = 0; i < this.savedParseExceptionReports.size(); ++i) {
            reports.add(this.savedParseExceptionReports.getLatest(i));
        }
        return reports;
    }

    @VisibleForTesting
    public void logParseExceptionHelper(Exception e) {
        if (this.logParseExceptions) {
            LOG.error(e, "Encountered parse exception", new Object[0]);
        }
    }
}

